/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Logger;

class VolumeDataReader
extends SurfaceReader {
    protected int dataType;
    protected boolean precalculateVoxelData;
    protected boolean allowMapData;
    protected Point3f point;

    VolumeDataReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.dataType = this.params.dataType;
        this.precalculateVoxelData = true;
        this.allowMapData = true;
    }

    void setup() {
        this.jvxlFileHeaderBuffer = new StringBuffer("volume data read from file\n\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected boolean readVolumeParameters() {
        this.setup();
        this.initializeVolumetricData();
        return true;
    }

    protected boolean readVolumeData(boolean bl) {
        try {
            this.readSurfaceData(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected void readVoxelDataIndividually(boolean bl) throws Exception {
        if (bl && !this.allowMapData) {
            return;
        }
        this.voxelData = bl ? new float[this.nPointsX][this.nPointsY][this.nPointsZ] : (float[][][])null;
        this.volumeData.setVoxelData(this.voxelData);
        if (!bl || this.volumeData.sr != null) {
            return;
        }
        for (int i = 0; i < this.nPointsX; ++i) {
            float[][] fArrayArray = new float[this.nPointsY][];
            this.voxelData[i] = fArrayArray;
            int n = 0;
            for (int j = 0; j < this.nPointsY; ++j) {
                fArrayArray[j] = new float[this.nPointsZ];
                float[] fArray = fArrayArray[j];
                int n2 = 0;
                while (n2 < this.nPointsZ) {
                    fArray[n2] = this.getValue(i, j, n2, n);
                    ++n2;
                    ++n;
                }
            }
        }
    }

    protected int setVoxelRange(int n, float f, float f2, float f3, int n2) {
        int n3;
        if (f >= f2) {
            f = -10.0f;
            f2 = 10.0f;
        }
        float f4 = f2 - f;
        float f5 = this.params.resolution;
        if (f5 != Float.MAX_VALUE) {
            f3 = f5;
        }
        if ((n3 = (int)(f4 * f3) + 1) > n2) {
            if ((this.dataType & 0x100) > 0) {
                if (f5 == Float.MAX_VALUE) {
                    Logger.info("Maximum number of voxels for index=" + n + " exceeded (" + n3 + ") -- set to " + n2);
                    n3 = n2;
                } else {
                    Logger.info("Warning -- high number of grid points: " + n3);
                }
            } else if (f5 == Float.MAX_VALUE) {
                n3 = n2;
            }
        }
        f3 = (float)(n3 - 1) / f4;
        this.voxelCounts[n] = n3;
        float f6 = this.volumeData.volumetricVectorLengths[n] = 1.0f / f3;
        Logger.info("isosurface resolution for axis " + (n + 1) + " set to " + f3 + " points/Angstrom; " + this.voxelCounts[n] + " voxels");
        switch (n) {
            case 0: {
                this.volumetricVectors[0].set(f6, 0.0f, 0.0f);
                this.volumetricOrigin.x = f;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, f6, 0.0f);
                this.volumetricOrigin.y = f;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, f6);
                this.volumetricOrigin.z = f;
                if (this.isEccentric) {
                    this.eccentricityMatrix.transform(this.volumetricOrigin);
                }
                if (this.center.x == Float.MAX_VALUE) break;
                this.volumetricOrigin.add(this.center);
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.transform(this.volumetricVectors[n]);
        }
        return this.voxelCounts[n];
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        if (this.precalculateVoxelData) {
            this.generateCube();
        } else {
            this.readVoxelDataIndividually(bl);
        }
    }

    protected void generateCube() {
        Logger.info("data type: user volumeData");
        Logger.info("voxel grid origin:" + this.volumetricOrigin);
        for (int i = 0; i < 3; ++i) {
            Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
        }
        Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
    }

    protected void closeReader() {
    }
}

