/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.Logger;

class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private float psi_Znuc = 1.0f;
    private float sphere_radiusAngstroms;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private float radius;
    private float ppa;
    private int maxGrid;
    private final Point3f ptPsi = new Point3f();
    private static final float[] fact = new float[20];

    IsoShapeReader(SurfaceGenerator surfaceGenerator, float f) {
        super(surfaceGenerator);
        this.sphere_radiusAngstroms = f;
    }

    IsoShapeReader(SurfaceGenerator surfaceGenerator, int n, int n2, int n3, float f) {
        super(surfaceGenerator);
        this.psi_n = n;
        this.psi_l = n2;
        this.psi_m = n3;
        this.psi_Znuc = f;
        this.sphere_radiusAngstroms = 0.0f;
    }

    protected void setup() {
        this.volumeData.sr = this;
        this.precalculateVoxelData = false;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        String string = "sphere";
        switch (this.dataType) {
            case 270: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.autoScaleOrbital();
                this.ppa = 5.0f;
                this.maxGrid = 40;
                string = "hydrogen-like orbital";
                break;
            }
            case 70: 
            case 71: {
                string = "lp";
                this.vertexDataOnly = true;
                this.radius = 0.0f;
                this.ppa = 1.0f;
                this.maxGrid = 1;
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.radius = 1.1f * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
                    this.radius /= this.eccentricityScale;
                }
                this.ppa = 10.0f;
                this.maxGrid = 21;
                string = "lobe";
                break;
            }
            case 67: {
                string = "ellipsoid(thermal)";
                this.radius = 3.0f * this.sphere_radiusAngstroms;
                this.ppa = 10.0f;
                this.maxGrid = 22;
                break;
            }
            case 66: {
                string = "ellipsoid";
            }
            default: {
                this.radius = 1.2f * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ppa = 10.0f;
                this.maxGrid = 22;
            }
        }
        this.setVoxelRange(0, -this.radius, this.radius, this.ppa, this.maxGrid);
        this.setVoxelRange(1, -this.radius, this.radius, this.ppa, this.maxGrid);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ppa, this.maxGrid);
        } else {
            this.setVoxelRange(2, 0.0f, this.radius / this.eccentricityRatio, this.ppa, this.maxGrid);
        }
        this.setHeader(string + "\n");
    }

    public float getValue(int n, int n2, int n3, int n4) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptPsi);
        return this.getValueAtPoint(this.ptPsi);
    }

    public float getValueAtPoint(Point3f point3f) {
        point3f.sub(this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.transform(point3f);
        }
        if (this.isAnisotropic) {
            point3f.x /= this.anisotropy[0];
            point3f.y /= this.anisotropy[1];
            point3f.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0f) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - (float)Math.sqrt(point3f.x * point3f.x + point3f.y * point3f.y + point3f.z * point3f.z) / (float)Math.sqrt(this.params.anisoB[0] * point3f.x * point3f.x + this.params.anisoB[1] * point3f.y * point3f.y + this.params.anisoB[2] * point3f.z * point3f.z + this.params.anisoB[3] * point3f.x * point3f.y + this.params.anisoB[4] * point3f.x * point3f.z + this.params.anisoB[5] * point3f.y * point3f.z);
            }
            return this.sphere_radiusAngstroms - (float)Math.sqrt(point3f.x * point3f.x + point3f.y * point3f.y + point3f.z * point3f.z);
        }
        float f = (float)this.hydrogenAtomPsi(point3f);
        return this.allowNegative || f >= 0.0f ? f : 0.0f;
    }

    private void setHeader(String string) {
        this.jvxlFileHeaderBuffer = new StringBuffer(string);
        if (this.sphere_radiusAngstroms > 0.0f) {
            this.jvxlFileHeaderBuffer.append(" rad=").append(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").append(this.psi_n).append(", l=").append(this.psi_l).append(", m=").append(this.psi_m).append(" Znuc=").append(this.psi_Znuc).append(" res=").append(this.ppa).append(" rad=").append(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private void calcFactors(int n, int n2, int n3) {
        int n4;
        int n5 = Math.abs(n3);
        double d = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / 0.52918, 1.5) * Math.sqrt((double)(fact[n - n2 - 1] / 2.0f / (float)n) / Math.pow(fact[n + n2], 3.0));
        double d2 = fact[n + n2] * fact[n + n2];
        double d3 = Math.pow(2.0, -n2) * (double)fact[n2] * (double)fact[n2 + n5] * Math.sqrt((float)(2 * n2 + 1) * fact[n2 - n5] / 2.0f / fact[n2 + n5]);
        for (n4 = 0; n4 <= n - n2 - 1; ++n4) {
            this.rfactor[n4] = d * d2 / (double)fact[n4] / (double)fact[n - n2 - n4 - 1] / (double)fact[2 * n2 + n4 + 1];
        }
        for (n4 = n5; n4 <= n2; ++n4) {
            this.pfactor[n4] = Math.pow(-1.0, n2 - n4) * d3 / (double)fact[n4] / (double)fact[n2 + n5 - n4] / (double)fact[n2 - n4] / (double)fact[n4 - n5];
        }
    }

    private void autoScaleOrbital() {
        double d;
        if (this.params.cutoff == 0.0f) {
            d = 0.01f;
        } else {
            d = Math.abs(this.params.cutoff / 2.0f);
            if (this.params.isSquared) {
                d = Math.sqrt(d / 2.0);
            }
        }
        float f = 0.0f;
        this.radius = 100.0f;
        while (this.radius > 0.0f) {
            double d2 = this.radialPart(this.radius);
            if (Math.abs(d2) >= d && f == 0.0f) {
                f = this.radius;
            }
            this.radius -= 1.0f;
        }
        this.radius = f + 1.0f;
        if (this.isAnisotropic) {
            float f2 = 0.0f;
            int n = 3;
            while (--n >= 0) {
                if (!(this.anisotropy[n] > f2)) continue;
                f2 = this.anisotropy[n];
            }
            this.radius *= f2;
        }
        Logger.info("radial extent set to " + this.radius + " for cutoff " + this.params.cutoff);
    }

    private double radialPart(double d) {
        double d2 = 2.0 * (double)this.psi_Znuc * d / (double)this.psi_n / 0.52918;
        double d3 = 0.0;
        for (int i = 0; i <= this.psi_n - this.psi_l - 1; ++i) {
            d3 += Math.pow(-d2, i) * this.rfactor[i];
        }
        return Math.exp(-d2 / 2.0) * Math.pow(d2, this.psi_l) * d3;
    }

    private double hydrogenAtomPsi(Point3f point3f) {
        double d = point3f.x * point3f.x + point3f.y * point3f.y;
        double d2 = this.radialPart(Math.sqrt(d + (double)(point3f.z * point3f.z)));
        double d3 = Math.atan2(point3f.y, point3f.x);
        double d4 = Math.atan2(Math.sqrt(d), point3f.z);
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        int n = Math.abs(this.psi_m);
        double d7 = 0.0;
        for (int i = n; i <= this.psi_l; ++i) {
            d7 += Math.pow(1.0 + d5, i - n) * Math.pow(1.0 - d5, this.psi_l - i) * this.pfactor[i];
        }
        double d8 = Math.abs(Math.pow(d6, n)) * d7;
        double d9 = this.psi_m == 0 ? 1.0 : (this.psi_m > 0 ? Math.cos((double)this.psi_m * d3) * 1.414214 : Math.sin((double)(-this.psi_m) * d3) * 1.414214);
        if (Math.abs(d9) < 1.0E-10) {
            d9 = 0.0;
        }
        return d2 * d8 * d9;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        switch (this.params.dataType) {
            case 70: 
            case 71: {
                this.ptPsi.set(0.0f, 0.0f, this.eccentricityScale / 2.0f);
                this.eccentricityMatrixInverse.transform(this.ptPsi);
                this.ptPsi.add(this.center);
                this.addVertexCopy(this.center, 0.0f, 0);
                this.addVertexCopy(this.ptPsi, 0.0f, 0);
                this.addTriangleCheck(0, 0, 0, 0, 0, false, 0);
                return;
            }
        }
        super.readSurfaceData(bl);
    }

    static {
        IsoShapeReader.fact[0] = 1.0f;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (float)i;
        }
    }
}

