/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.MepCalculationInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class AtomPropertyMapper
extends AtomDataReader {
    private MepCalculationInterface m;
    private String mepType;
    private int calcType = 0;
    private boolean doSmoothProperty;
    private AtomIndexIterator iter;
    private float smoothingPower;

    AtomPropertyMapper(SurfaceGenerator surfaceGenerator, String string) {
        super(surfaceGenerator);
        this.mepType = string;
    }

    protected void setup() {
        super.setup();
        this.volumeData.sr = this;
        this.volumeData.doIterate = false;
        this.point = this.params.point;
        this.doSmoothProperty = this.params.propertySmoothing;
        this.doUseIterator = true;
        if (this.doSmoothProperty) {
            this.smoothingPower = this.params.propertySmoothingPower;
            if (this.smoothingPower < 0.0f) {
                this.smoothingPower = 0.0f;
            } else if (this.smoothingPower > 10.0f) {
                this.smoothingPower = 10.0f;
            }
            if (this.smoothingPower == 0.0f) {
                this.doSmoothProperty = false;
            }
            this.smoothingPower = (this.smoothingPower - 11.0f) / 2.0f;
        }
        this.maxDistance = this.params.propertyDistanceMax;
        if (this.mepType != null) {
            this.doSmoothProperty = true;
            if (this.params.mep_calcType >= 0) {
                this.calcType = this.params.mep_calcType;
            }
            this.m = (MepCalculationInterface)Interface.getOptionInterface("quantum." + this.mepType + "Calculation");
        }
        if (!this.doSmoothProperty && this.maxDistance == 2.1474836E9f) {
            this.maxDistance = 5.0f;
        }
        this.getAtoms(Float.NaN, false, true);
        this.setHeader("property", this.params.calculationType);
        this.setRangesAndAddAtoms(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, 0);
        this.params.cutoff = 0.0f;
    }

    protected void initializeMapping() {
        if (Logger.debugging) {
            Logger.startTimer();
        }
        if (this.bsNearby != null) {
            this.bsMySelected.or(this.bsNearby);
        }
        this.iter = this.atomDataServer.getSelectedAtomIterator(this.bsMySelected, false, false);
    }

    protected void finalizeMapping() {
        this.iter.release();
        this.iter = null;
        if (Logger.debugging) {
            Logger.checkTimer("property mapping time");
        }
    }

    protected void generateCube() {
    }

    public float getValueAtPoint(Point3f point3f) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = this.doSmoothProperty ? 0.0f : Float.NaN;
        float f4 = 0.0f;
        this.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, point3f, this.maxDistance);
        while (this.iter.hasNext()) {
            int n = this.myIndex[this.iter.next()];
            boolean bl = n >= this.firstNearbyAtom;
            Point3f point3f2 = this.atomXyz[n];
            float f5 = this.atomProp[n];
            if (Float.isNaN(f5)) continue;
            float f6 = point3f.distanceSquared(point3f2);
            if (bl) {
                if (f6 < f2) {
                    f2 = f6;
                    if (!this.doSmoothProperty && f2 < f) {
                        f = f6;
                        f3 = Float.NaN;
                    }
                }
            } else if (f6 < f) {
                f = f6;
                if (!this.doSmoothProperty) {
                    f3 = f5;
                }
            }
            if (this.m != null) {
                f3 += this.m.valueFor(f5, f6, this.calcType);
                continue;
            }
            if (!this.doSmoothProperty) continue;
            f6 = (float)Math.pow(f6, this.smoothingPower);
            f4 += f6;
            f3 += f6 * f5;
        }
        return this.m != null ? f3 : (this.doSmoothProperty ? (f4 == 0.0f || f2 < f ? Float.NaN : f3 / f4) : f3);
    }
}

