/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ___Exporter {
    protected Viewer viewer;
    protected double privateKey;
    protected JmolRendererInterface jmolRenderer;
    protected StringBuffer output;
    protected BufferedWriter bw;
    private FileOutputStream os;
    protected String fileName;
    protected String commandLineOptions;
    protected boolean isToFile;
    protected Graphics3D g3d;
    protected short backgroundColix;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    protected Point3f lightSource = Graphics3D.getLightSource();
    protected Point3f fixedRotationCenter;
    protected Point3f referenceCenter;
    protected Point3f cameraPosition;
    protected float cameraDistance;
    protected float aperatureAngle;
    protected float scalePixelsPerAngstrom;
    int exportType;
    protected final Point3f tempP1 = new Point3f();
    protected final Point3f tempP2 = new Point3f();
    protected final Point3f tempP3 = new Point3f();
    protected final Point3f center = new Point3f();
    protected final Vector3f tempV1 = new Vector3f();
    protected final Vector3f tempV2 = new Vector3f();
    protected final Vector3f tempV3 = new Vector3f();
    protected final AxisAngle4f tempA = new AxisAngle4f();
    protected int nBytes;
    protected String commentChar;
    private int nText;
    private int nImage;
    public short lineWidthMad;

    void setRenderer(JmolRendererInterface jmolRendererInterface) {
        this.jmolRenderer = jmolRendererInterface;
    }

    boolean initializeOutput(Viewer viewer, double d, Graphics3D graphics3D, Object object) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.privateKey = d;
        this.backgroundColix = viewer.getObjectColix(0);
        this.center.set(viewer.getRotationCenter());
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = graphics3D.getSlab();
        this.depthZ = graphics3D.getDepth();
        Point3f[] point3fArray = viewer.getCameraFactors();
        this.referenceCenter = point3fArray[0];
        this.cameraPosition = point3fArray[1];
        this.fixedRotationCenter = point3fArray[2];
        this.cameraDistance = point3fArray[3].x;
        this.aperatureAngle = point3fArray[3].y;
        this.scalePixelsPerAngstrom = point3fArray[3].z;
        this.isToFile = object instanceof String;
        if (this.isToFile) {
            this.fileName = (String)object;
            int n = this.fileName.indexOf(":::");
            if (n > 0) {
                this.commandLineOptions = this.fileName.substring(n + 3);
                this.fileName = this.fileName.substring(0, n);
            }
            try {
                File file = new File(this.fileName);
                System.out.println("__Exporter writing to " + file.getAbsolutePath());
                this.os = new FileOutputStream(this.fileName);
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        } else {
            this.output = (StringBuffer)object;
        }
        this.outputHeader();
        return true;
    }

    protected abstract void outputHeader();

    protected void output(String string) {
        this.nBytes += string.length();
        try {
            if (this.bw == null) {
                this.output.append(string);
            } else {
                this.bw.write(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void outputComment(String string) {
        if (this.commentChar != null) {
            this.output(this.commentChar + string + "\n");
        }
    }

    protected void outputFooter() {
    }

    String finalizeOutput() {
        this.outputFooter();
        if (!this.isToFile) {
            return this.output.toString();
        }
        try {
            this.bw.flush();
            this.bw.close();
            this.os = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "ERROR EXPORTING FILE";
        }
        return "OK " + this.nBytes + " " + this.jmolRenderer.getExportName() + " " + this.fileName;
    }

    protected List<Short> getColorList(int n, short[] sArray, int n2, BitSet bitSet, Map<Short, Integer> map) {
        int n3;
        int n4 = 0;
        ArrayList<Short> arrayList = new ArrayList<Short>();
        boolean bl = bitSet == null;
        int n5 = n3 = bl ? n2 - 1 : bitSet.nextSetBit(0);
        while (n5 >= 0) {
            Short s = sArray[n5];
            if (!map.containsKey(s)) {
                arrayList.add(s);
                map.put(s, n + n4++);
            }
            n5 = bl ? n5 - 1 : bitSet.nextSetBit(n5 + 1);
        }
        return arrayList;
    }

    abstract void drawAtom(Atom var1);

    void drawSurface(MeshSurface meshSurface) {
        int n;
        int n2 = meshSurface.vertexCount;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = meshSurface.polygonCount;
        BitSet bitSet = meshSurface.bsPolygons;
        int n5 = meshSurface.haveQuads ? 4 : 3;
        int[][] nArray = meshSurface.polygonIndexes;
        boolean bl = bitSet == null;
        int n6 = n = bl ? n4 - 1 : bitSet.nextSetBit(0);
        while (n6 >= 0) {
            n3 += n5 == 4 && nArray[n6].length == 4 ? 2 : 1;
            n6 = bl ? n6 - 1 : bitSet.nextSetBit(n6 + 1);
        }
        if (n3 == 0) {
            return;
        }
        Point3f[] point3fArray = (Point3f[])meshSurface.getVertices();
        Vector3f[] vector3fArray = (Vector3f[])meshSurface.normals;
        short s = meshSurface.colix;
        short[] sArray = meshSurface.isColorSolid ? null : meshSurface.vertexColixes;
        short[] sArray2 = meshSurface.isColorSolid ? meshSurface.polygonColixes : null;
        Hashtable<Short, Integer> hashtable = new Hashtable<Short, Integer>();
        List<Short> list = null;
        if (sArray2 != null) {
            list = this.getColorList(0, sArray2, n4, bitSet, hashtable);
        } else if (sArray != null) {
            list = this.getColorList(0, sArray, n2, null, hashtable);
        }
        this.outputSurface(point3fArray, vector3fArray, sArray, nArray, sArray2, n2, n4, n3, bitSet, n5, s, list, hashtable, meshSurface.offset);
    }

    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, List<Short> list, Map<Short, Integer> map, Point3f point3f) {
    }

    abstract void drawPixel(short var1, int var2, int var3, int var4, int var5);

    abstract void drawTextPixel(int var1, int var2, int var3, int var4);

    abstract void fillConeScreen(short var1, byte var2, int var3, Point3f var4, Point3f var5, boolean var6);

    abstract void drawCylinder(Point3f var1, Point3f var2, short var3, short var4, byte var5, int var6, int var7);

    abstract void fillCylinderScreenMad(short var1, byte var2, int var3, Point3f var4, Point3f var5);

    abstract void fillSphere(short var1, int var2, Point3f var3);

    protected abstract void fillTriangle(short var1, Point3f var2, Point3f var3, Point3f var4, boolean var5);

    void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        this.outputComment("start image " + ++this.nImage);
        this.g3d.plotImage(n, n2, n3, image, this.jmolRenderer, s, n4, n5);
        this.outputComment("end image " + this.nImage);
    }

    void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        this.outputComment("start text " + ++this.nText + ": " + string);
        this.g3d.plotText(n, n2, n3, this.g3d.getColorArgbOrGray(s), string, font3D, this.jmolRenderer);
        this.outputComment("end text " + this.nText + ": " + string);
    }
}

