/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolViewer;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BinaryDocument;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomSetCollectionReader {
    public boolean isBinary;
    public AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected BinaryDocument doc;
    protected String readerName;
    public Map<String, Object> htParams;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected long ptLine;
    public int[] latticeCells;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    public boolean continuing = true;
    protected JmolViewer viewer;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    public boolean applySymmetryToBonds;
    protected boolean doCheckUnitCell;
    protected boolean getHeader;
    protected boolean isSequential;
    protected int templateAtomCount;
    public int modelNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BitSet bsModels;
    public String calculationType = "?";
    protected String spaceGroup;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    protected float[] notionalUnitCell;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    protected SymmetryInterface symmetry;
    protected OutputStream os;
    protected boolean iHaveFractionalCoordinates;
    protected boolean doPackUnitCell;
    private boolean doConvertToFractional;
    private boolean merging;
    private boolean fileCoordinatesAreFractional;
    private float symmetryRange;
    private int[] firstLastStep;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    private Point3f fileScaling;
    private Point3f fileOffset;
    private Point3f fileOffsetFractional;
    private Point3f unitCellOffset;
    private String supercell;
    private boolean unitCellOffsetFractional;
    String fileName;
    public boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    protected Matrix3f matUnitCellOrientation;
    protected BitSet bsFilter;
    protected String filter;
    private boolean haveAtomFilter;
    private boolean filterAltLoc;
    private boolean filterGroup3;
    private boolean filterChain;
    private boolean filterAtomType;
    protected boolean filterHetero;
    private boolean filterEveryNth;
    private int filterN;
    private boolean doSetOrientation;
    protected boolean addVibrations;
    protected boolean useAltNames;
    public boolean readMolecularOrbitals;
    private String filter1;
    private String filter2;
    private String previousScript;

    void setup(String string, Map<String, Object> map, Object object) {
        this.htParams = map;
        this.fileName = string.replace('\\', '/');
        if (object instanceof BufferedReader) {
            this.reader = (BufferedReader)object;
        } else if (object instanceof BinaryDocument) {
            this.doc = (BinaryDocument)object;
        }
    }

    Object readData() throws Exception {
        this.initialize();
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        try {
            this.initializeReader();
            if (this.doc == null) {
                if (this.line == null && this.continuing) {
                    this.readLine();
                }
                while (this.line != null && this.continuing) {
                    if (!this.checkLine()) continue;
                    this.readLine();
                }
            } else {
                this.processBinaryDocument(this.doc);
            }
            this.finalizeReader();
        }
        catch (Throwable throwable) {
            this.setError(throwable);
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.doc != null) {
            this.doc.close();
        }
        return this.finish();
    }

    protected Object readData(Object object) throws Exception {
        this.initialize();
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        this.initializeReader();
        this.processXml(object);
        return this.finish();
    }

    protected void processXml(Object object) {
    }

    protected void processBinaryDocument(BinaryDocument binaryDocument) throws Exception {
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean isLastModel(int n) {
        return this.desiredModelNumber > 0 || n >= this.lastModelNumber;
    }

    protected void finalizeReader() throws Exception {
        this.applySymmetryAndSetTrajectory();
    }

    private Object finish() {
        String string;
        String string2;
        String string3 = (String)this.htParams.get("loadState");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("loadState", string3 == null ? "" : string3);
        string3 = (String)this.htParams.get("smilesString");
        if (string3 != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("smilesString", string3);
        }
        if (!this.htParams.containsKey("templateAtomCount")) {
            this.htParams.put("templateAtomCount", this.atomSetCollection.getAtomCount());
        }
        if (this.htParams.containsKey("bsFilter")) {
            this.htParams.put("filteredAtomCount", BitSetUtil.cardinalityOf((BitSet)this.htParams.get("bsFilter")));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((string2 = (string = this.atomSetCollection.getFileTypeName())).indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileName", this.fileName, n);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileType", string2, n);
        }
        this.atomSetCollection.freeze();
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + this.fileName + "\ntype " + string;
        }
        if (this.atomSetCollection.getAtomCount() == 0) {
            return "No atoms found\nfor file " + this.fileName + "\ntype " + string;
        }
        return this.atomSetCollection;
    }

    private void setError(Throwable throwable) {
        throwable.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + throwable.getMessage();
    }

    private void initialize() {
        Object object;
        this.initializeSymmetry();
        this.viewer = (JmolViewer)this.htParams.get("viewer");
        this.htParams.remove("viewer");
        this.getHeader = this.htParams.containsKey("getHeader");
        this.isSequential = this.htParams.containsKey("isSequential");
        this.readerName = (String)this.htParams.get("readerName");
        if (this.htParams.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)this.htParams.get("vibrationNumber");
        } else if (this.htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)this.htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = this.htParams.containsKey("applySymmetryToBonds");
        this.bsFilter = (BitSet)this.htParams.get("bsFilter");
        this.setFilter((String)this.htParams.get("filter"));
        int n = this.htParams.containsKey("ptFile") ? (Integer)this.htParams.get("ptFile") : -1;
        this.isTrajectory = this.htParams.containsKey("isTrajectory");
        if (n > 0 && this.htParams.containsKey("firstLastSteps")) {
            object = ((List)this.htParams.get("firstLastSteps")).get(n - 1);
            if (object instanceof BitSet) {
                this.bsModels = (BitSet)object;
            } else {
                this.firstLastStep = (int[])object;
            }
        } else if (this.htParams.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])this.htParams.get("firstLastStep");
        } else if (this.htParams.containsKey("bsModels")) {
            this.bsModels = (BitSet)this.htParams.get("bsModels");
        }
        if (this.htParams.containsKey("templateAtomCount")) {
            this.templateAtomCount = (Integer)this.htParams.get("templateAtomCount");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = BitSetUtil.setBit(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = this.htParams.containsKey("symmetryRange") ? ((Float)this.htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.latticeCells = new int[3];
        if (this.htParams.containsKey("lattice")) {
            object = (Point3f)this.htParams.get("lattice");
            this.latticeCells[0] = (int)((Point3f)object).x;
            this.latticeCells[1] = (int)((Point3f)object).y;
            this.latticeCells[2] = (int)((Point3f)object).z;
            boolean bl = this.doPackUnitCell = this.htParams.containsKey("packed") || this.latticeCells[2] < 0;
        }
        if (this.htParams.containsKey("supercell")) {
            this.supercell = (String)this.htParams.get("supercell");
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (this.htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)this.htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)this.htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (this.htParams.containsKey("unitCellOffset")) {
            this.fileScaling = new Point3f(1.0f, 1.0f, 1.0f);
            this.fileOffset = (Point3f)this.htParams.get("unitCellOffset");
            this.fileOffsetFractional = new Point3f(this.fileOffset);
            this.unitCellOffsetFractional = this.htParams.containsKey("unitCellOffsetFractional");
        }
        if (this.htParams.containsKey("unitcell")) {
            object = (float[])this.htParams.get("unitcell");
            if (((E)object).length == 9) {
                this.addPrimitiveLatticeVector(0, (float[])object, 0);
                this.addPrimitiveLatticeVector(1, (float[])object, 3);
                this.addPrimitiveLatticeVector(2, (float[])object, 6);
            } else {
                this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            }
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
        this.merging = this.htParams.containsKey("merging");
        if (this.htParams.containsKey("OutputStream")) {
            this.os = (OutputStream)this.htParams.get("OutputStream");
        }
    }

    public boolean doGetModel(int n) {
        boolean bl;
        boolean bl2 = this.bsModels == null ? this.desiredModelNumber < 1 || n == this.desiredModelNumber : (n > this.lastModelNumber ? false : (bl = n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (bl && this.desiredModelNumber == 0) {
            this.atomSetCollection.discardPreviousAtoms();
        }
        this.haveModel |= bl;
        if (bl) {
            this.doProcessLines = true;
        }
        return bl;
    }

    protected void initializeSymmetry() {
        this.previousSpaceGroup = this.spaceGroup;
        this.previousUnitCell = this.notionalUnitCell;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int n = 22;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified!";
        }
        this.doCheckUnitCell = false;
    }

    protected void newAtomSet(String string) {
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.getCurrentAtomSetIndex() + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        Logger.debug(string);
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
        Logger.info("Setting space group name to " + this.spaceGroup);
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearUnitCell() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < this.notionalUnitCell.length; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0 && f == 1.0f || n == 3 && f == 0.0f) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.clearUnitCell();
        this.notionalUnitCell[0] = f;
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        if (f4 != 0.0f) {
            this.notionalUnitCell[3] = f4;
        }
        if (f5 != 0.0f) {
            this.notionalUnitCell[4] = f5;
        }
        if (f6 != 0.0f) {
            this.notionalUnitCell[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray, int n2) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0) {
            for (int i = 0; i < 6; ++i) {
                this.notionalUnitCell[i] = 0.0f;
            }
        }
        n = 6 + n * 3;
        this.notionalUnitCell[n++] = fArray[n2++];
        this.notionalUnitCell[n++] = fArray[n2++];
        this.notionalUnitCell[n] = fArray[n2];
        if (Float.isNaN(this.notionalUnitCell[0])) {
            for (n = 0; n < 6; ++n) {
                this.notionalUnitCell[n] = -1.0f;
            }
        }
        this.iHaveUnitCell = this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        this.checkUnitCellOffset();
        return true;
    }

    private void checkUnitCellOffset() {
        if (this.symmetry == null || this.fileOffsetFractional == null) {
            return;
        }
        this.fileOffset.set(this.fileOffsetFractional);
        if (this.unitCellOffsetFractional != this.fileCoordinatesAreFractional) {
            if (this.unitCellOffsetFractional) {
                this.symmetry.toCartesian(this.fileOffset, false);
            } else {
                this.symmetry.toFractional(this.fileOffset, false);
            }
        }
    }

    protected SymmetryInterface getSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
        this.checkUnitCellOffset();
    }

    protected void setFilter(String string) {
        if (string != null) {
            string = string.toUpperCase();
        }
        this.filter = string;
        this.doSetOrientation = !this.checkFilter("NOORIENT");
        this.addVibrations = !this.checkFilter("NOVIB");
        this.readMolecularOrbitals = !this.checkFilter("NOMO");
        this.useAltNames = this.checkFilter("ALTNAME");
        if (this.filter == null) {
            return;
        }
        this.filterAtomType = this.checkFilter("*.") || this.checkFilter("!.");
        this.filterHetero = this.checkFilter("HETATM");
        this.filterGroup3 = this.checkFilter("[");
        this.filterChain = this.checkFilter(":");
        this.filterAltLoc = this.checkFilter("%");
        this.filterEveryNth = this.checkFilter("/=");
        if (this.filterEveryNth) {
            this.filterN = this.parseInt(this.filter.substring(this.filter.indexOf("/=") + 2));
        }
        if (this.filterN == Integer.MIN_VALUE) {
            this.filterEveryNth = false;
        }
        boolean bl = this.haveAtomFilter = this.filterAtomType || this.filterGroup3 || this.filterChain || this.filterAltLoc || this.filterHetero || this.filterEveryNth || this.checkFilter("/=");
        if (this.bsFilter == null) {
            this.bsFilter = new BitSet();
            this.htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
            if (this.haveAtomFilter) {
                this.filter1 = this.filter;
                int n = this.filter.indexOf("|");
                if (n >= 0) {
                    this.filter1 = this.filter.substring(0, n).trim() + ";";
                    this.filter2 = ";" + this.filter.substring(n).trim();
                }
            }
        }
    }

    public boolean checkFilter(String string) {
        return this.filter != null && this.filter.indexOf(string) >= 0;
    }

    public void setAtomCoord(Atom atom) {
        if (this.fileScaling != null) {
            atom.x = atom.x * this.fileScaling.x + this.fileOffset.x;
            atom.y = atom.y * this.fileScaling.y + this.fileOffset.y;
            atom.z = atom.z * this.fileScaling.z + this.fileOffset.z;
        }
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            if (!this.symmetry.haveUnitCell()) {
                this.symmetry.setUnitCell(this.notionalUnitCell);
            }
            this.symmetry.toFractional(atom, false);
            this.iHaveFractionalCoordinates = true;
        }
        this.doCheckUnitCell = true;
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.iHaveUnitCell && this.doCheckUnitCell) {
            this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
            this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell, this.matUnitCellOrientation, this.unitCellOffset);
            this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
            this.atomSetCollection.setSymmetryRange(this.symmetryRange);
            if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
                this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell, this.supercell);
                if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                    if (this.createSpaceGroup()) {
                        this.atomSetCollection.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
                        this.atomSetCollection.applySymmetry(this.symmetry);
                    }
                } else {
                    this.atomSetCollection.applySymmetry();
                }
            }
            if (this.iHaveFractionalCoordinates && this.merging && this.symmetry != null) {
                this.atomSetCollection.toCartesian(this.symmetry);
                this.atomSetCollection.setCoordinatesAreFractional(false);
                this.addVibrations = false;
            }
        }
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        this.initializeSymmetry();
    }

    protected boolean createSpaceGroup() {
        return this.getSymmetry().createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("!") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell);
    }

    public void checkLineForScript() {
        int n;
        Object object;
        if (this.line.indexOf("Jmol") >= 0) {
            if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", this.line);
                if (!this.line.endsWith("#noautobond")) {
                    this.line = this.line + "#noautobond";
                }
            }
            if (this.line.indexOf("Jmol data min") >= 0) {
                Logger.info(this.line);
                float[] fArray = new float[15];
                this.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), fArray);
                object = new Point3f(fArray[0], fArray[1], fArray[2]);
                Point3f point3f = new Point3f(fArray[3], fArray[4], fArray[5]);
                this.fileScaling = new Point3f(fArray[6], fArray[7], fArray[8]);
                this.fileOffset = new Point3f(fArray[9], fArray[10], fArray[11]);
                Point3f point3f2 = new Point3f(fArray[12], fArray[13], fArray[14]);
                if (point3f2.x <= 0.0f) {
                    point3f2.x = 100.0f;
                }
                if (point3f2.y <= 0.0f) {
                    point3f2.y = 100.0f;
                }
                if (point3f2.z <= 0.0f) {
                    point3f2.z = 100.0f;
                }
                if (this.fileScaling.y == 0.0f) {
                    this.fileScaling.y = 1.0f;
                }
                if (this.fileScaling.z == 0.0f) {
                    this.fileScaling.z = 1.0f;
                }
                this.setFractionalCoordinates(true);
                this.latticeCells = new int[3];
                this.atomSetCollection.setLatticeCells(this.latticeCells, true, false, this.supercell);
                this.setUnitCell(point3f2.x * 2.0f / (point3f.x - ((Point3f)object).x), point3f2.y * 2.0f / (point3f.y - ((Point3f)object).y), point3f2.z * 2.0f / (point3f.z == ((Point3f)object).z ? 1.0f : point3f.z - ((Point3f)object).z), 90.0f, 90.0f, 90.0f);
                this.unitCellOffset = new Point3f(point3f2);
                this.unitCellOffset.scale(-1.0f);
                this.symmetry.toFractional(this.unitCellOffset, false);
                this.unitCellOffset.scaleAdd(-1.0f, (Tuple3f)object, this.unitCellOffset);
                this.symmetry.setUnitCellOffset(this.unitCellOffset);
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolDataScaling", new Point3f[]{object, point3f, point3f2});
            }
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            object = this.line.substring(n + 11, this.line.length());
            if (((String)object).indexOf("#") >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf("#"));
            }
            this.addJmolScript((String)object);
            this.line = this.line.substring(0, n).trim();
        }
    }

    protected void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.os != null && this.line != null) {
            this.os.write(this.line.getBytes());
            this.os.write(10);
        }
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected void parseStringInfestedFloatArray(String string, float[] fArray) {
        Parser.parseStringInfestedFloatArray(string, null, fArray);
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String string, float[] fArray, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(string), fArray, n);
    }

    public static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    public float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }
}

