/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.twoatoms;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.control.EFieldControlPanel;
import edu.colorado.phet.moleculepolarity.common.control.ElectronegativityControlNode;
import edu.colorado.phet.moleculepolarity.common.control.MPControlPanelNode;
import edu.colorado.phet.moleculepolarity.common.control.SurfaceControlPanel;
import edu.colorado.phet.moleculepolarity.common.view.BondCharacterNode;
import edu.colorado.phet.moleculepolarity.common.view.DiatomicMoleculeNode;
import edu.colorado.phet.moleculepolarity.common.view.DipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.MPCanvas;
import edu.colorado.phet.moleculepolarity.common.view.NegativePlateNode;
import edu.colorado.phet.moleculepolarity.common.view.PositivePlateNode;
import edu.colorado.phet.moleculepolarity.common.view.SurfaceColorKeyNode;
import edu.colorado.phet.moleculepolarity.common.view.ViewProperties;
import edu.colorado.phet.moleculepolarity.twoatoms.TwoAtomsModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Frame;

public class TwoAtomsCanvas
extends MPCanvas {
    public TwoAtomsCanvas(TwoAtomsModel twoAtomsModel, final ViewProperties viewProperties, Frame frame) {
        final DiatomicMoleculeNode diatomicMoleculeNode = new DiatomicMoleculeNode(twoAtomsModel.molecule);
        NegativePlateNode negativePlateNode = new NegativePlateNode(twoAtomsModel.eField);
        PositivePlateNode positivePlateNode = new PositivePlateNode(twoAtomsModel.eField);
        ElectronegativityControlNode electronegativityControlNode = new ElectronegativityControlNode(twoAtomsModel.molecule.atomA, twoAtomsModel.molecule, MPConstants.ELECTRONEGATIVITY_RANGE, 0.2);
        ElectronegativityControlNode electronegativityControlNode2 = new ElectronegativityControlNode(twoAtomsModel.molecule.atomB, twoAtomsModel.molecule, MPConstants.ELECTRONEGATIVITY_RANGE, 0.2);
        final BondCharacterNode bondCharacterNode = new BondCharacterNode(twoAtomsModel.molecule);
        final SurfaceColorKeyNode.ElectrostaticPotentialColorKeyNode electrostaticPotentialColorKeyNode = new SurfaceColorKeyNode.ElectrostaticPotentialColorKeyNode();
        final SurfaceColorKeyNode.ElectronDensityColorKeyNode electronDensityColorKeyNode = new SurfaceColorKeyNode.ElectronDensityColorKeyNode();
        MPControlPanelNode mPControlPanelNode = new MPControlPanelNode(frame, new Resettable[]{twoAtomsModel, viewProperties}, new MPControlPanelNode.MPVerticalPanel(MPStrings.VIEW){
            {
                super(string);
                this.add(new MPControlPanelNode.MPCheckBoxWithIcon(MPStrings.BOND_DIPOLE, DipoleNode.createIcon(MPColors.BOND_DIPOLE), viewProperties.bondDipolesVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.PARTIAL_CHARGES, viewProperties.partialChargesVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.BOND_CHARACTER, viewProperties.bondCharacterVisible));
            }
        }, new SurfaceControlPanel(viewProperties.surfaceType), new EFieldControlPanel(twoAtomsModel.eField.enabled));
        this.addChild(negativePlateNode);
        this.addChild(positivePlateNode);
        this.addChild(electronegativityControlNode);
        this.addChild(electronegativityControlNode2);
        this.addChild(mPControlPanelNode);
        this.addChild(bondCharacterNode);
        this.addChild(electrostaticPotentialColorKeyNode);
        this.addChild(electronDensityColorKeyNode);
        this.addChild(diatomicMoleculeNode);
        double d = twoAtomsModel.molecule.location.getX();
        double d2 = twoAtomsModel.molecule.location.getY();
        negativePlateNode.setOffset(d - 250.0 - negativePlateNode.getFullBoundsReference().getWidth(), d2 - 225.0);
        positivePlateNode.setOffset(d + 250.0, negativePlateNode.getYOffset());
        ((PNode)electronegativityControlNode).setOffset(d - electronegativityControlNode.getFullBoundsReference().getWidth() - 5.0, 50.0);
        ((PNode)electronegativityControlNode2).setOffset(d + 5.0, electronegativityControlNode.getYOffset());
        electrostaticPotentialColorKeyNode.setOffset(d - electrostaticPotentialColorKeyNode.getFullBoundsReference().getWidth() / 2.0, negativePlateNode.getFullBoundsReference().getMaxY() - 10.0);
        electronDensityColorKeyNode.setOffset(electrostaticPotentialColorKeyNode.getOffset());
        bondCharacterNode.setOffset(d - bondCharacterNode.getFullBoundsReference().getWidth() / 2.0, electronegativityControlNode.getFullBoundsReference().getMaxY() + 10.0 - PNodeLayoutUtils.getOriginYOffset(bondCharacterNode));
        mPControlPanelNode.setOffset(positivePlateNode.getFullBoundsReference().getMaxX() + 25.0, positivePlateNode.getYOffset());
        viewProperties.bondDipolesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                diatomicMoleculeNode.setBondDipoleVisible(bl);
            }
        });
        viewProperties.partialChargesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                diatomicMoleculeNode.setPartialChargesVisible(bl);
            }
        });
        viewProperties.bondCharacterVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                bondCharacterNode.setVisible(bl);
            }
        });
        viewProperties.surfaceType.addObserver(new VoidFunction1<ViewProperties.SurfaceType>(){

            @Override
            public void apply(ViewProperties.SurfaceType surfaceType) {
                diatomicMoleculeNode.setSurface(surfaceType);
                electrostaticPotentialColorKeyNode.setVisible(surfaceType == ViewProperties.SurfaceType.ELECTROSTATIC_POTENTIAL);
                electronDensityColorKeyNode.setVisible(surfaceType == ViewProperties.SurfaceType.ELECTRON_DENSITY);
            }
        });
    }
}

