/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.threeatoms;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.control.EFieldControlPanel;
import edu.colorado.phet.moleculepolarity.common.control.ElectronegativityControlNode;
import edu.colorado.phet.moleculepolarity.common.control.MPControlPanelNode;
import edu.colorado.phet.moleculepolarity.common.view.DipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.MPCanvas;
import edu.colorado.phet.moleculepolarity.common.view.NegativePlateNode;
import edu.colorado.phet.moleculepolarity.common.view.PositivePlateNode;
import edu.colorado.phet.moleculepolarity.common.view.TriatomicMoleculeNode;
import edu.colorado.phet.moleculepolarity.common.view.ViewProperties;
import edu.colorado.phet.moleculepolarity.threeatoms.ThreeAtomsModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Frame;

public class ThreeAtomsCanvas
extends MPCanvas {
    public ThreeAtomsCanvas(ThreeAtomsModel threeAtomsModel, final ViewProperties viewProperties, Frame frame) {
        final TriatomicMoleculeNode triatomicMoleculeNode = new TriatomicMoleculeNode(threeAtomsModel.molecule);
        NegativePlateNode negativePlateNode = new NegativePlateNode(threeAtomsModel.eField);
        PositivePlateNode positivePlateNode = new PositivePlateNode(threeAtomsModel.eField);
        ElectronegativityControlNode electronegativityControlNode = new ElectronegativityControlNode(threeAtomsModel.molecule.atomA, threeAtomsModel.molecule, MPConstants.ELECTRONEGATIVITY_RANGE, 0.2);
        ElectronegativityControlNode electronegativityControlNode2 = new ElectronegativityControlNode(threeAtomsModel.molecule.atomB, threeAtomsModel.molecule, MPConstants.ELECTRONEGATIVITY_RANGE, 0.2);
        ElectronegativityControlNode electronegativityControlNode3 = new ElectronegativityControlNode(threeAtomsModel.molecule.atomC, threeAtomsModel.molecule, MPConstants.ELECTRONEGATIVITY_RANGE, 0.2);
        MPControlPanelNode mPControlPanelNode = new MPControlPanelNode(frame, new Resettable[]{threeAtomsModel, viewProperties}, new MPControlPanelNode.MPVerticalPanel(MPStrings.VIEW){
            {
                super(string);
                this.add(new MPControlPanelNode.MPCheckBoxWithIcon(MPStrings.BOND_DIPOLES, DipoleNode.createIcon(MPColors.BOND_DIPOLE), viewProperties.bondDipolesVisible));
                this.add(new MPControlPanelNode.MPCheckBoxWithIcon(MPStrings.MOLECULAR_DIPOLE, DipoleNode.createIcon(MPColors.MOLECULAR_DIPOLE), viewProperties.molecularDipoleVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.PARTIAL_CHARGES, viewProperties.partialChargesVisible));
            }
        }, new EFieldControlPanel(threeAtomsModel.eField.enabled));
        this.addChild(negativePlateNode);
        this.addChild(positivePlateNode);
        this.addChild(electronegativityControlNode);
        this.addChild(electronegativityControlNode2);
        this.addChild(electronegativityControlNode3);
        this.addChild(mPControlPanelNode);
        this.addChild(triatomicMoleculeNode);
        double d = threeAtomsModel.molecule.location.getX();
        double d2 = threeAtomsModel.molecule.location.getY();
        negativePlateNode.setOffset(d - 300.0 - negativePlateNode.getFullBoundsReference().getWidth(), d2 - 225.0);
        positivePlateNode.setOffset(d + 300.0, negativePlateNode.getYOffset());
        ((PNode)electronegativityControlNode2).setOffset(d - electronegativityControlNode2.getFullBoundsReference().getWidth() / 2.0, 50.0);
        ((PNode)electronegativityControlNode).setOffset(electronegativityControlNode2.getFullBounds().getMinX() - electronegativityControlNode.getFullBoundsReference().getWidth() - 10.0, electronegativityControlNode2.getYOffset());
        ((PNode)electronegativityControlNode3).setOffset(electronegativityControlNode2.getFullBounds().getMaxX() + 10.0, electronegativityControlNode2.getYOffset());
        mPControlPanelNode.setOffset(positivePlateNode.getFullBoundsReference().getMaxX() + 25.0, positivePlateNode.getYOffset());
        viewProperties.bondDipolesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                triatomicMoleculeNode.setBondDipolesVisible(bl);
            }
        });
        viewProperties.molecularDipoleVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                triatomicMoleculeNode.setMolecularDipoleVisible(bl);
            }
        });
        viewProperties.partialChargesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                triatomicMoleculeNode.setPartialChargesVisible(bl);
            }
        });
    }
}

