/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.realmolecules;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.control.MPControlPanelNode;
import edu.colorado.phet.moleculepolarity.common.control.MoleculeControlNode;
import edu.colorado.phet.moleculepolarity.common.control.SurfaceControlPanel;
import edu.colorado.phet.moleculepolarity.common.view.DipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.ElectronegativityTableNode;
import edu.colorado.phet.moleculepolarity.common.view.JmolViewerNode;
import edu.colorado.phet.moleculepolarity.common.view.MPCanvas;
import edu.colorado.phet.moleculepolarity.common.view.SurfaceColorKeyNode;
import edu.colorado.phet.moleculepolarity.common.view.ViewProperties;
import edu.colorado.phet.moleculepolarity.realmolecules.RealMoleculesModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Dimension;
import java.awt.Frame;
import org.jmol.api.JmolViewer;

public class RealMoleculesCanvas
extends MPCanvas {
    private static final Dimension JMOL_VIEWER_SIZE = new Dimension(450, 450);
    private final JmolViewerNode viewerNode;

    public RealMoleculesCanvas(RealMoleculesModel realMoleculesModel, final ViewProperties viewProperties, Frame frame) {
        this.viewerNode = new JmolViewerNode(realMoleculesModel.currentMolecule, this.getBackground(), JMOL_VIEWER_SIZE);
        final ElectronegativityTableNode electronegativityTableNode = new ElectronegativityTableNode(this.viewerNode);
        MoleculeControlNode moleculeControlNode = new MoleculeControlNode(realMoleculesModel.getMolecules(), realMoleculesModel.currentMolecule);
        final SurfaceColorKeyNode.ElectrostaticPotentialColorKeyNode electrostaticPotentialColorKeyNode = new SurfaceColorKeyNode.ElectrostaticPotentialColorKeyNode();
        final SurfaceColorKeyNode.RainbowElectrostaticPotentialColorKeyNode rainbowElectrostaticPotentialColorKeyNode = new SurfaceColorKeyNode.RainbowElectrostaticPotentialColorKeyNode();
        final SurfaceColorKeyNode.ElectronDensityColorKeyNode electronDensityColorKeyNode = new SurfaceColorKeyNode.ElectronDensityColorKeyNode();
        MPControlPanelNode mPControlPanelNode = new MPControlPanelNode(frame, new Resettable[]{realMoleculesModel, viewProperties}, new MPControlPanelNode.MPVerticalPanel(MPStrings.VIEW){
            {
                super(string);
                this.add(new MPControlPanelNode.MPCheckBoxWithIcon(MPStrings.BOND_DIPOLES, DipoleNode.createIcon(MPColors.BOND_DIPOLE), viewProperties.bondDipolesVisible));
                this.add(new MPControlPanelNode.MPCheckBoxWithIcon(MPStrings.MOLECULAR_DIPOLE, DipoleNode.createIcon(MPColors.MOLECULAR_DIPOLE), viewProperties.molecularDipoleVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.PARTIAL_CHARGES, viewProperties.partialChargesVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.ATOM_ELECTRONEGATIVITIES, viewProperties.electronegativityTableVisible));
                this.add(new MPControlPanelNode.MPCheckBox(MPStrings.ATOM_LABELS, viewProperties.atomLabelsVisible));
            }
        }, new SurfaceControlPanel(viewProperties.surfaceType));
        this.setBackground(BufferedImageUtils.getPixelColor(BufferedImageUtils.toBufferedImage(this.viewerNode.toImage()), 0, 0));
        this.addChild(mPControlPanelNode);
        this.addChild(electronegativityTableNode);
        this.addChild(electrostaticPotentialColorKeyNode);
        this.addChild(rainbowElectrostaticPotentialColorKeyNode);
        this.addChild(electronDensityColorKeyNode);
        this.addChild(this.viewerNode);
        this.addChild(moleculeControlNode);
        double d = (this.getStageSize().getWidth() - this.viewerNode.getFullBoundsReference().getWidth() - mPControlPanelNode.getFullBoundsReference().getWidth() - 75.0) / 2.0;
        ((PNode)moleculeControlNode).setOffset(d + this.viewerNode.getFullBoundsReference().getWidth() / 2.0 - moleculeControlNode.getFullBoundsReference().getWidth() / 2.0, 25.0);
        this.viewerNode.setOffset(d, moleculeControlNode.getFullBoundsReference().getMaxY() + 10.0);
        electrostaticPotentialColorKeyNode.setOffset(this.viewerNode.getFullBoundsReference().getCenterX() - electrostaticPotentialColorKeyNode.getFullBoundsReference().getWidth() / 2.0, this.viewerNode.getFullBoundsReference().getMaxY() + 10.0);
        rainbowElectrostaticPotentialColorKeyNode.setOffset(electrostaticPotentialColorKeyNode.getOffset());
        electronDensityColorKeyNode.setOffset(electrostaticPotentialColorKeyNode.getOffset());
        electronegativityTableNode.setOffset(this.viewerNode.getFullBoundsReference().getCenterX() - electronegativityTableNode.getFullBoundsReference().getWidth() / 2.0, electrostaticPotentialColorKeyNode.getFullBoundsReference().getMaxY() + 20.0);
        mPControlPanelNode.setOffset(this.viewerNode.getFullBoundsReference().getMaxX() + 75.0, this.viewerNode.getFullBoundsReference().getCenterY() - mPControlPanelNode.getFullBoundsReference().getHeight() / 2.0);
        viewProperties.bondDipolesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                RealMoleculesCanvas.this.viewerNode.setBondDipolesVisible(bl);
            }
        });
        viewProperties.molecularDipoleVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                RealMoleculesCanvas.this.viewerNode.setMolecularDipoleVisible(bl);
            }
        });
        viewProperties.partialChargesVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                RealMoleculesCanvas.this.viewerNode.setPartialChargeVisible(bl);
            }
        });
        viewProperties.atomLabelsVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                RealMoleculesCanvas.this.viewerNode.setAtomLabelsVisible(bl);
            }
        });
        viewProperties.electronegativityTableVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                electronegativityTableNode.setVisible(bl);
            }
        });
        viewProperties.surfaceType.addObserver(new VoidFunction1<ViewProperties.SurfaceType>(){

            @Override
            public void apply(ViewProperties.SurfaceType surfaceType) {
                RealMoleculesCanvas.this.viewerNode.setSurfaceType(surfaceType);
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                electrostaticPotentialColorKeyNode.setVisible(viewProperties.surfaceType.get() == ViewProperties.SurfaceType.ELECTROSTATIC_POTENTIAL && JmolViewerNode.RAINBOW_MEP.get() == false);
                rainbowElectrostaticPotentialColorKeyNode.setVisible(viewProperties.surfaceType.get() == ViewProperties.SurfaceType.ELECTROSTATIC_POTENTIAL && JmolViewerNode.RAINBOW_MEP.get() != false);
                electronDensityColorKeyNode.setVisible(viewProperties.surfaceType.get() == ViewProperties.SurfaceType.ELECTRON_DENSITY);
            }
        };
        richSimpleObserver.observe(viewProperties.surfaceType, JmolViewerNode.RAINBOW_MEP);
    }

    public JmolViewer getJmolViewer() {
        return this.viewerNode.getViewer();
    }
}

