/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.moleculepolarity.common.control.BondAngleHandler;
import edu.colorado.phet.moleculepolarity.common.control.MoleculeAngleHandler;
import edu.colorado.phet.moleculepolarity.common.control.RotateCursorHandler;
import edu.colorado.phet.moleculepolarity.common.model.TriatomicMolecule;
import edu.colorado.phet.moleculepolarity.common.view.AtomNode;
import edu.colorado.phet.moleculepolarity.common.view.BondAngleArrowsNode;
import edu.colorado.phet.moleculepolarity.common.view.BondDipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.BondNode;
import edu.colorado.phet.moleculepolarity.common.view.MolecularDipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.PartialChargeNode;
import edu.umd.cs.piccolo.PNode;

public class TriatomicMoleculeNode
extends PhetPNode {
    private final PNode partialChargeNodeA;
    private final PNode partialChargeNodeB;
    private final PNode partialChargeNodeC;
    private final PNode bondDipoleABNode;
    private final PNode bondDipoleBCNode;
    private final PNode molecularDipoleNode;

    public TriatomicMoleculeNode(TriatomicMolecule triatomicMolecule) {
        final BondNode bondNode = new BondNode(triatomicMolecule.bondAB);
        final BondNode bondNode2 = new BondNode(triatomicMolecule.bondBC);
        final AtomNode atomNode = new AtomNode(triatomicMolecule.atomA);
        final AtomNode atomNode2 = new AtomNode(triatomicMolecule.atomB);
        final AtomNode atomNode3 = new AtomNode(triatomicMolecule.atomC);
        final BondAngleArrowsNode bondAngleArrowsNode = new BondAngleArrowsNode(triatomicMolecule, triatomicMolecule.atomA);
        final BondAngleArrowsNode bondAngleArrowsNode2 = new BondAngleArrowsNode(triatomicMolecule, triatomicMolecule.atomC);
        this.partialChargeNodeA = new PartialChargeNode.OppositePartialChargeNode(triatomicMolecule.atomA, triatomicMolecule.bondAB);
        this.partialChargeNodeB = new PartialChargeNode.CompositePartialChargeNode(triatomicMolecule.atomB, triatomicMolecule);
        this.partialChargeNodeC = new PartialChargeNode.OppositePartialChargeNode(triatomicMolecule.atomC, triatomicMolecule.bondBC);
        this.bondDipoleABNode = new BondDipoleNode(triatomicMolecule.bondAB);
        this.bondDipoleBCNode = new BondDipoleNode(triatomicMolecule.bondBC);
        this.molecularDipoleNode = new MolecularDipoleNode(triatomicMolecule);
        this.addChild(new PNode(){
            {
                this.addChild(bondNode);
                this.addChild(bondNode2);
                this.addChild(bondAngleArrowsNode);
                this.addChild(bondAngleArrowsNode2);
                this.addChild(atomNode);
                this.addChild(atomNode2);
                this.addChild(atomNode3);
            }
        });
        this.addChild(new PNode(){
            {
                this.addChild(TriatomicMoleculeNode.this.partialChargeNodeA);
                this.addChild(TriatomicMoleculeNode.this.partialChargeNodeB);
                this.addChild(TriatomicMoleculeNode.this.partialChargeNodeC);
                this.addChild(TriatomicMoleculeNode.this.bondDipoleABNode);
                this.addChild(TriatomicMoleculeNode.this.bondDipoleBCNode);
                this.addChild(TriatomicMoleculeNode.this.molecularDipoleNode);
            }
        });
        bondNode.addInputEventListener(new RotateCursorHandler());
        bondNode2.addInputEventListener(new RotateCursorHandler());
        atomNode2.addInputEventListener(new RotateCursorHandler());
        bondNode.addInputEventListener(new MoleculeAngleHandler(triatomicMolecule, this));
        bondNode2.addInputEventListener(new MoleculeAngleHandler(triatomicMolecule, this));
        atomNode2.addInputEventListener(new MoleculeAngleHandler(triatomicMolecule, this));
        atomNode.addInputEventListener(new CursorHandler());
        atomNode3.addInputEventListener(new CursorHandler());
        atomNode.addInputEventListener(new BondAngleHandler(triatomicMolecule, triatomicMolecule.bondAngleA, atomNode, bondAngleArrowsNode));
        atomNode3.addInputEventListener(new BondAngleHandler(triatomicMolecule, triatomicMolecule.bondAngleC, atomNode3, bondAngleArrowsNode2));
        bondAngleArrowsNode.setVisible(false);
        bondAngleArrowsNode2.setVisible(false);
    }

    public void setPartialChargesVisible(boolean bl) {
        this.partialChargeNodeA.setVisible(bl);
        this.partialChargeNodeB.setVisible(bl);
        this.partialChargeNodeC.setVisible(bl);
    }

    public void setBondDipolesVisible(boolean bl) {
        this.bondDipoleABNode.setVisible(bl);
        this.bondDipoleBCNode.setVisible(bl);
    }

    public void setMolecularDipoleVisible(boolean bl) {
        this.molecularDipoleNode.setVisible(bl);
    }
}

