/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.moleculepolarity.common.control.MoleculeAngleHandler;
import edu.colorado.phet.moleculepolarity.common.control.RotateCursorHandler;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public abstract class SurfaceNode
extends PComposite {
    public SurfaceNode(Molecule2D molecule2D) {
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                if (SurfaceNode.this.getVisible()) {
                    SurfaceNode.this.updateNode();
                }
            }
        };
        for (Atom atom : molecule2D.getAtoms()) {
            atom.location.addObserver(simpleObserver, false);
            atom.electronegativity.addObserver(simpleObserver, false);
        }
        this.addInputEventListener(new RotateCursorHandler());
        this.addInputEventListener(new MoleculeAngleHandler(molecule2D, this));
    }

    protected abstract void updateNode();

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateNode();
        }
    }

    protected static Shape createCloudShape(Atom atom, double d) {
        double d2 = d * atom.getDiameter();
        double d3 = atom.location.get().getX() - d2 / 2.0;
        double d4 = atom.location.get().getY() - d2 / 2.0;
        return new Ellipse2D.Double(d3, d4, d2, d2);
    }

    protected static AffineTransform createTransform(Molecule2D molecule2D) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(molecule2D.location.getX(), molecule2D.location.getY());
        affineTransform.rotate(molecule2D.angle.get());
        return affineTransform;
    }
}

