/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Bond;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartialChargeNode
extends PComposite {
    private static final double REFERENCE_MAGNITUDE = MPConstants.ELECTRONEGATIVITY_RANGE.getLength();
    protected final RichSimpleObserver observer;

    public PartialChargeNode(final Atom atom, final Function0<ImmutableVector2D> function0) {
        final PText pText = new PText(){
            {
                this.setFont(new PhetFont(32));
                this.setTextPaint(Color.BLACK);
            }
        };
        this.addChild(pText);
        this.observer = new RichSimpleObserver(){

            public void update() {
                double d = atom.partialCharge.get();
                pText.setVisible(d != 0.0);
                if (d != 0.0) {
                    if (d > 0.0) {
                        pText.setText("\u03b4+");
                    } else {
                        pText.setText("\u03b4-");
                    }
                    double d2 = Math.abs(1.0 * d / REFERENCE_MAGNITUDE);
                    if (d2 != 0.0) {
                        pText.setScale(d2);
                        pText.setOffset(-pText.getFullBoundsReference().getWidth() / 2.0, -pText.getFullBoundsReference().getHeight() / 2.0);
                    }
                    ImmutableVector2D immutableVector2D = (ImmutableVector2D)function0.apply();
                    double d3 = atom.getDiameter() / 2.0 + Math.max(PartialChargeNode.this.getFullBoundsReference().getWidth(), PartialChargeNode.this.getFullBoundsReference().getHeight()) / 2.0 + 3.0;
                    ImmutableVector2D immutableVector2D2 = immutableVector2D.times(d3);
                    PartialChargeNode.this.setOffset(atom.location.get().plus(immutableVector2D2).toPoint2D());
                }
            }
        };
        this.observer.observe(atom.partialCharge, atom.location);
    }

    public static class CompositePartialChargeNode
    extends PartialChargeNode {
        public CompositePartialChargeNode(Atom atom, final Molecule2D molecule2D) {
            super(atom, new Function0<ImmutableVector2D>(){

                @Override
                public ImmutableVector2D apply() {
                    ImmutableVector2D immutableVector2D = molecule2D.dipole.get().getMagnitude() > 0.0 ? molecule2D.dipole.get().getRotatedInstance(Math.PI).getNormalizedInstance() : new ImmutableVector2D(1.0, molecule2D.dipole.get().getAngle());
                    return immutableVector2D;
                }
            });
            molecule2D.dipole.addObserver(this.observer);
        }
    }

    public static class OppositePartialChargeNode
    extends PartialChargeNode {
        public OppositePartialChargeNode(final Atom atom, final Bond bond) {
            super(atom, new Function0<ImmutableVector2D>(){

                @Override
                public ImmutableVector2D apply() {
                    ImmutableVector2D immutableVector2D = new ImmutableVector2D(bond.getCenter(), atom.location.get());
                    if (immutableVector2D.getMagnitude() > 0.0) {
                        immutableVector2D = immutableVector2D.getNormalizedInstance();
                    }
                    return immutableVector2D;
                }
            });
        }
    }
}

