/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.jmolphet.JmolUtil;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingDragListener;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.common.model.Element;
import edu.colorado.phet.moleculepolarity.common.model.Molecule3D;
import edu.colorado.phet.moleculepolarity.common.view.ViewProperties;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmolViewerNode
extends PhetPNode {
    private static final Logger LOGGER = LoggingUtils.getLogger(JmolViewerNode.class.getCanonicalName());
    public static final Property<Boolean> RAINBOW_MEP = new Property<Boolean>(false);
    public final Property<Molecule3D> molecule;
    private final ViewerPanel viewerPanel;
    private boolean bondDipolesVisible;
    private boolean molecularDipoleVisible;
    private boolean partialChargeVisible;
    private boolean atomLabelsVisible;
    private ViewProperties.SurfaceType surfaceType;

    public JmolViewerNode(final Property<Molecule3D> property, Color color, Dimension dimension) {
        this.viewerPanel = new ViewerPanel(property.get(), color, dimension);
        this.viewerPanel.addMouseListener(new SimSharingDragListener("jmolViewerNode", new Function0<Parameter[]>(){

            @Override
            public Parameter[] apply() {
                return new Parameter[]{Parameter.param("currentMolecule", ((Molecule3D)property.get()).getName())};
            }
        }));
        this.addChild(new PSwing(this.viewerPanel));
        this.molecule = new Property<Molecule3D>(property.get());
        this.addInputEventListener(new CursorHandler());
        property.addObserver(new VoidFunction1<Molecule3D>(){

            @Override
            public void apply(Molecule3D molecule3D) {
                JmolViewerNode.this.setMolecule(molecule3D);
            }
        });
        RAINBOW_MEP.addObserver(new SimpleObserver(){

            public void update() {
                JmolViewerNode.this.setSurfaceType(JmolViewerNode.this.surfaceType);
            }
        });
    }

    public JmolViewer getViewer() {
        return this.viewerPanel.getViewer();
    }

    protected void adjustAtomColors() {
        this.doScript("select oxygen; color " + JmolViewerNode.toJmolColor(PhetColorScheme.RED_COLORBLIND));
        this.doScript("select all");
    }

    public static String toJmolColor(Color color) {
        return MessageFormat.format("[{0},{1},{2}]", color.getRed(), color.getGreen(), color.getBlue());
    }

    public Object doScript(String string) {
        return this.viewerPanel.doScript(string);
    }

    private void setMolecule(Molecule3D molecule3D) {
        this.viewerPanel.setMolecule(molecule3D);
        this.molecule.set(molecule3D);
        this.adjustAtomColors();
        this.setBallAndStick();
        this.setAtomLabelsVisible(this.atomLabelsVisible);
        this.setBondDipolesVisible(this.bondDipolesVisible);
        this.setMolecularDipoleVisible(this.molecularDipoleVisible);
        this.setSurfaceType(this.surfaceType);
        this.doScript("hover off");
        this.updateAtomLabels();
        this.updateTranslucency();
    }

    private void setBallAndStick() {
        this.doScript("wireframe 0.1 ");
        this.doScript("spacefill 25%");
        this.doScript("color bonds " + JmolViewerNode.toJmolColor(MPColors.BOND));
    }

    public void setAtomLabelsVisible(boolean bl) {
        this.atomLabelsVisible = bl;
        this.updateAtomLabels();
    }

    private void updateAtomLabels() {
        String string = "";
        if (this.atomLabelsVisible || this.partialChargeVisible) {
            if (this.atomLabelsVisible) {
                string = string + " %[atomName]";
            }
            if (this.partialChargeVisible) {
                if (this.atomLabelsVisible) {
                    string = string + "|";
                }
                string = string + "\u03b4=%.2[partialCharge]";
            }
            this.doScript("label " + string);
            this.doScript("set labelalignment center; set labeloffset 0 0");
            this.doScript("color labels black");
            this.doScript("font labels 18 sanserif");
        } else {
            this.doScript("label off");
        }
    }

    private void updateTranslucency() {
        String string = this.bondDipolesVisible || this.molecularDipoleVisible ? "0.25" : "0.0";
        this.doScript("color atoms translucent " + string);
        this.doScript("color bonds translucent " + string);
    }

    public void setBondDipolesVisible(boolean bl) {
        this.bondDipolesVisible = bl;
        if (bl) {
            this.doScript("dipole bonds on width 0.05");
        } else {
            this.doScript("dipole bonds off");
        }
        this.updateTranslucency();
    }

    public void setMolecularDipoleVisible(boolean bl) {
        this.molecularDipoleVisible = bl;
        if (bl) {
            this.doScript("dipole molecular on width 0.05");
        } else {
            this.doScript("dipole molecular off");
        }
        this.updateTranslucency();
    }

    public void setPartialChargeVisible(boolean bl) {
        this.partialChargeVisible = bl;
        this.updateAtomLabels();
    }

    public void setSurfaceType(ViewProperties.SurfaceType surfaceType) {
        this.surfaceType = surfaceType;
        if (surfaceType == ViewProperties.SurfaceType.ELECTROSTATIC_POTENTIAL) {
            if (this.isHomogeneousDiatomic()) {
                if (RAINBOW_MEP.get().booleanValue()) {
                    this.doScript("isosurface VDW color " + JmolViewerNode.toJmolColor(MPColors.NEUTRAL_GREEN) + " translucent");
                } else {
                    this.doScript("isosurface VDW color white translucent");
                }
            } else if (RAINBOW_MEP.get().booleanValue()) {
                this.doScript("isosurface VDW map MEP translucent");
            } else {
                this.doScript("isosurface VDW map MEP colorscheme \"RWB\" translucent");
            }
        } else if (surfaceType == ViewProperties.SurfaceType.ELECTRON_DENSITY) {
            if (this.isHomogeneousDiatomic()) {
                this.doScript("isosurface VDW color " + JmolViewerNode.toJmolColor(MPColors.NEUTRAL_GRAY) + " translucent");
            } else {
                this.doScript("isosurface VDW map MEP colorscheme \"BW\" translucent");
            }
        } else {
            this.doScript("isosurface off");
        }
    }

    private boolean isHomogeneousDiatomic() {
        Object object = this.doScript("numberOfAtoms = {*}.length\nhomogeneousDiatomic = \"true\"\nif ( numberOfAtoms == 2 ) {\n    firstElement = {*}[0].element\n    for ( i = 0; i < numberOfAtoms; i++ ) {\n        nextElement = {*}[i].element\n        if ( firstElement != nextElement ) {\n            homogeneousDiatomic = \"false\"\n        }\n    }\n}\nelse {\n    homogeneousDiatomic = \"false\"\n}\nprint homogeneousDiatomic");
        if (object == null) {
            throw new RuntimeException("Jmol script returned null status");
        }
        return JmolViewerNode.parseBoolean(object);
    }

    public ArrayList<Element> getElements() {
        Object object = this.doScript("n = {*}.length\nfor ( i = 0; i < n; i++ ) {\n    print {*}[i].elemno\n    print {*}[i].color\n}");
        if (object == null) {
            throw new RuntimeException("Jmol script returned null status");
        }
        ArrayList<Integer> arrayList = JmolViewerNode.parseIntegers(object, " \n{}");
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        for (int i = 0; i < arrayList.size(); i += 4) {
            int n = arrayList.get(i);
            Color color = new Color(arrayList.get(i + 1), arrayList.get(i + 2), arrayList.get(i + 3));
            arrayList2.add(new Element(n, color));
        }
        return arrayList2;
    }

    private static boolean parseBoolean(Object object) {
        return object.toString().trim().equals("true");
    }

    private static ArrayList<Integer> parseIntegers(Object object, String string) {
        String string2 = object.toString().trim();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = (int)Double.parseDouble(string3);
            arrayList.add(n);
        }
        return arrayList;
    }

    private static class ViewerPanel
    extends JPanel {
        private final JmolViewer viewer;

        public ViewerPanel(Molecule3D molecule3D, Color color, Dimension dimension) {
            this.setPreferredSize(dimension);
            org.jmol.util.Logger.setLogLevel(PhetApplication.getInstance().isDeveloperControlsEnabled() ? 3 : 1);
            this.viewer = JmolViewer.allocateViewer(this, new SmarterJmolAdapter(), null, null, null, "-applet", null);
            this.viewer.setColorBackground(JmolViewerNode.toJmolColor(color));
            this.viewer.setFrankOn(false);
            this.viewer.setBooleanProperty("antialiasDisplay", true);
            this.viewer.setBooleanProperty("autoBond", false);
            this.viewer.setFloatProperty("dipoleScale", 0.8f);
            JmolUtil.unbindMouse(this.viewer);
            JmolUtil.bindRotateLeft(this.viewer);
            this.setMolecule(molecule3D);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = new Dimension();
            this.getSize(dimension);
            Rectangle rectangle = new Rectangle();
            graphics.getClipBounds(rectangle);
            this.viewer.renderScreenImage(graphics, dimension, rectangle);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        public Object doScript(String string) {
            return this.viewer.scriptWaitStatus(string, null);
        }

        public void setMolecule(Molecule3D molecule3D) {
            String string = this.viewer.openStringInline(molecule3D.getData());
            if (string != null) {
                LOGGER.log(Level.SEVERE, "Jmol says: " + string);
            }
        }
    }
}

