/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Element;
import edu.colorado.phet.moleculepolarity.common.view.JmolViewerNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class ElectronegativityTableNode
extends PComposite {
    private final ArrayList<Cell> cells;

    public ElectronegativityTableNode(final JmolViewerNode jmolViewerNode) {
        PText pText = new PText(MPStrings.ATOM_ELECTRONEGATIVITIES){
            {
                this.setFont(new PhetFont(12));
            }
        };
        this.addChild(pText);
        this.cells = new ArrayList<Cell>(){
            {
                this.add(new Cell("H", 1, 2.1));
                this.add(new Cell("B", 5, 2.0));
                this.add(new Cell("C", 6, 2.5));
                this.add(new Cell("N", 7, 3.0));
                this.add(new Cell("O", 8, 3.5));
                this.add(new Cell("F", 9, 4.0));
                this.add(new Cell("Cl", 17, 3.0));
            }
        };
        double d = 0.0;
        Cell cell = this.cells.get(0);
        this.addChild(cell);
        cell.setOffset(d, 0.0);
        d = d + cell.getFullBoundsReference().getWidth() + 12.0;
        for (int i = 1; i < this.cells.size() - 1; ++i) {
            Cell cell2 = this.cells.get(i);
            this.addChild(cell2);
            cell2.setOffset(d, 0.0);
            d = cell2.getFullBoundsReference().getMaxX();
        }
        Cell cell3 = this.cells.get(this.cells.size() - 1);
        this.addChild(cell3);
        cell3.setOffset(d += 12.0, 0.0);
        pText.setOffset((cell3.getFullBoundsReference().getMaxX() - cell.getFullBoundsReference().getMinX()) / 2.0 - pText.getFullBoundsReference().getWidth() / 2.0, cell3.getFullBoundsReference().getMaxY() + 2.0);
        jmolViewerNode.molecule.addObserver(new SimpleObserver(){

            public void update() {
                ElectronegativityTableNode.this.reset();
                ArrayList<Element> arrayList = jmolViewerNode.getElements();
                for (Element element : arrayList) {
                    ElectronegativityTableNode.this.setColor(element.elementNumber, element.color);
                }
            }
        });
    }

    private void reset() {
        for (Cell cell : this.cells) {
            cell.disable();
        }
    }

    private void setColor(int n, Color color) {
        for (Cell cell : this.cells) {
            if (cell.getElementNumber() != n) continue;
            cell.enable(color);
            break;
        }
    }

    private static class Cell
    extends PComposite {
        private static final Dimension SIZE = new Dimension(50, 65);
        private static final Color BACKGROUND_COLOR = new Color(210, 210, 210);
        private static final Color NORMAL_TEXT_COLOR = BACKGROUND_COLOR.darker();
        private static final Color HIGHLIGHTED_TEXT_COLOR = Color.BLACK;
        private final int elementNumber;
        private final PPath backgroundNode;
        private final PText elementNameNode;
        private final PText electronegativityNode;

        public Cell(String string, int n, double d) {
            this.elementNumber = n;
            this.backgroundNode = new PPath(new Rectangle2D.Double(0.0, 0.0, Cell.SIZE.width, Cell.SIZE.height)){
                {
                    this.setPaint(BACKGROUND_COLOR);
                }
            };
            this.elementNameNode = new PText(string){
                {
                    this.setFont(new PhetFont(1, 24));
                    this.setTextPaint(NORMAL_TEXT_COLOR);
                }
            };
            this.electronegativityNode = new PText(new DecimalFormat("0.0").format(d)){
                {
                    this.setFont(new PhetFont(18));
                    this.setTextPaint(NORMAL_TEXT_COLOR);
                }
            };
            this.addChild(this.backgroundNode);
            this.addChild(this.elementNameNode);
            this.addChild(this.electronegativityNode);
            this.elementNameNode.setOffset(this.backgroundNode.getFullBoundsReference().getCenterX() - this.elementNameNode.getFullBoundsReference().getWidth() / 2.0, 3.0);
            this.electronegativityNode.setOffset(this.backgroundNode.getFullBoundsReference().getCenterX() - this.electronegativityNode.getFullBoundsReference().getWidth() / 2.0, this.backgroundNode.getFullBoundsReference().getMaxY() - this.electronegativityNode.getFullBoundsReference().getHeight() - 3.0);
        }

        public int getElementNumber() {
            return this.elementNumber;
        }

        public void enable(Color color) {
            this.backgroundNode.setPaint(color);
            this.elementNameNode.setTextPaint(HIGHLIGHTED_TEXT_COLOR);
            this.electronegativityNode.setTextPaint(HIGHLIGHTED_TEXT_COLOR);
        }

        public void disable() {
            this.backgroundNode.setPaint(BACKGROUND_COLOR);
            this.elementNameNode.setTextPaint(NORMAL_TEXT_COLOR);
            this.electronegativityNode.setTextPaint(NORMAL_TEXT_COLOR);
        }
    }
}

