/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DipoleNode
extends PPath {
    private static final double REFERENCE_MAGNITUDE = MPConstants.ELECTRONEGATIVITY_RANGE.getLength();
    private static final Dimension HEAD_SIZE = new Dimension(12, 20);
    private static final Dimension CROSS_SIZE = new Dimension(10, 10);
    private final Property<ImmutableVector2D> dipole;

    protected DipoleNode(Property<ImmutableVector2D> property, Color color) {
        this.setPaint(color);
        this.dipole = property;
        property.addObserver(new SimpleObserver(){

            public void update() {
                DipoleNode.this.updateNode();
            }
        });
    }

    private void updateNode() {
        if (this.dipole.get().getMagnitude() == 0.0) {
            this.setPathTo(new Rectangle2D.Double());
        } else {
            Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(this.getDipoleViewLength(), 0.0), DipoleNode.HEAD_SIZE.height, DipoleNode.HEAD_SIZE.width, 4.0, 0.5, true);
            Shape shape = this.createCross(arrow);
            Area area = new Area(arrow.getShape());
            area.add(new Area(shape));
            this.setPathTo(area);
            this.setRotation(this.dipole.get().getAngle());
        }
    }

    private Shape createCross(Arrow arrow) {
        double d = Math.abs(arrow.getTipLocation().getX() - arrow.getTailLocation().getX());
        double d2 = arrow.getHeadScale();
        double d3 = d2 * 20.0 * d / 135.0;
        double d4 = d2 * (double)DipoleNode.CROSS_SIZE.height * d / 135.0;
        double d5 = d2 * (double)DipoleNode.CROSS_SIZE.width;
        if (arrow.getTipLocation().getX() < arrow.getTailLocation().getX()) {
            d3 = -1.0 * d3 - d4;
        }
        return new Rectangle2D.Double(d3, -d5 / 2.0, d4, d5);
    }

    protected double getDipoleViewLength() {
        return this.dipole.get().getMagnitude() * (135.0 / REFERENCE_MAGNITUDE);
    }

    public static Icon createIcon(Color color) {
        DipoleNode dipoleNode = new DipoleNode((Property)new Property<ImmutableVector2D>(new ImmutableVector2D(0.5, 0.0)), color){};
        return new ImageIcon(dipoleNode.toImage());
    }
}

