/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.common.control.MoleculeAngleHandler;
import edu.colorado.phet.moleculepolarity.common.control.RotateCursorHandler;
import edu.colorado.phet.moleculepolarity.common.model.DiatomicMolecule;
import edu.colorado.phet.moleculepolarity.common.view.AtomNode;
import edu.colorado.phet.moleculepolarity.common.view.BondDipoleNode;
import edu.colorado.phet.moleculepolarity.common.view.BondNode;
import edu.colorado.phet.moleculepolarity.common.view.DiatomicElectronDensityNode;
import edu.colorado.phet.moleculepolarity.common.view.DiatomicElectrostaticPotentialNode;
import edu.colorado.phet.moleculepolarity.common.view.PartialChargeNode;
import edu.colorado.phet.moleculepolarity.common.view.ViewProperties;
import edu.umd.cs.piccolo.PNode;

public class DiatomicMoleculeNode
extends PhetPNode {
    private final PNode electrostaticPotentialNode;
    private final PNode electronDensityNode;
    private final PNode partialChargeNodeA;
    private final PNode partialChargeNodeB;
    private final PNode bondDipoleNode;

    public DiatomicMoleculeNode(DiatomicMolecule diatomicMolecule) {
        this.electrostaticPotentialNode = new DiatomicElectrostaticPotentialNode(diatomicMolecule, MPConstants.ELECTRONEGATIVITY_RANGE, MPColors.RWB_GRADIENT);
        this.electronDensityNode = new DiatomicElectronDensityNode(diatomicMolecule, MPConstants.ELECTRONEGATIVITY_RANGE, MPColors.BW_GRADIENT);
        final BondNode bondNode = new BondNode(diatomicMolecule.bond);
        final AtomNode atomNode = new AtomNode(diatomicMolecule.atomA);
        final AtomNode atomNode2 = new AtomNode(diatomicMolecule.atomB);
        this.partialChargeNodeA = new PartialChargeNode.OppositePartialChargeNode(diatomicMolecule.atomA, diatomicMolecule.bond);
        this.partialChargeNodeB = new PartialChargeNode.OppositePartialChargeNode(diatomicMolecule.atomB, diatomicMolecule.bond);
        this.bondDipoleNode = new BondDipoleNode(diatomicMolecule.bond);
        this.addChild(new PNode(){
            {
                this.addChild(DiatomicMoleculeNode.this.electrostaticPotentialNode);
                this.addChild(DiatomicMoleculeNode.this.electronDensityNode);
            }
        });
        this.addChild(new PNode(){
            {
                this.addChild(bondNode);
                this.addChild(atomNode);
                this.addChild(atomNode2);
            }
        });
        this.addChild(new PNode(){
            {
                this.addChild(DiatomicMoleculeNode.this.partialChargeNodeA);
                this.addChild(DiatomicMoleculeNode.this.partialChargeNodeB);
                this.addChild(DiatomicMoleculeNode.this.bondDipoleNode);
            }
        });
        this.addInputEventListener(new RotateCursorHandler());
        this.addInputEventListener(new MoleculeAngleHandler(diatomicMolecule, this));
    }

    public void setSurface(ViewProperties.SurfaceType surfaceType) {
        this.electrostaticPotentialNode.setVisible(surfaceType == ViewProperties.SurfaceType.ELECTROSTATIC_POTENTIAL);
        this.electronDensityNode.setVisible(surfaceType == ViewProperties.SurfaceType.ELECTRON_DENSITY);
    }

    public void setPartialChargesVisible(boolean bl) {
        this.partialChargeNodeA.setVisible(bl);
        this.partialChargeNodeB.setVisible(bl);
    }

    public void setBondDipoleVisible(boolean bl) {
        this.bondDipoleNode.setVisible(bl);
    }
}

