/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.colorado.phet.moleculepolarity.common.model.DiatomicMolecule;
import edu.colorado.phet.moleculepolarity.common.view.SurfaceNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DiatomicElectrostaticPotentialNode
extends SurfaceNode {
    private final DiatomicMolecule molecule;
    private final DoubleRange electronegativityRange;
    private final Color[] colors;
    private final PPath pathNodeA;
    private final PPath pathNodeB;

    public DiatomicElectrostaticPotentialNode(DiatomicMolecule diatomicMolecule, DoubleRange doubleRange, Color[] colorArray) {
        super(diatomicMolecule);
        assert (colorArray.length == 3);
        assert (diatomicMolecule.atomA.getDiameter() == diatomicMolecule.atomB.getDiameter());
        this.molecule = diatomicMolecule;
        this.electronegativityRange = doubleRange;
        this.colors = colorArray;
        this.pathNodeA = new PPath(){
            {
                this.setStroke(null);
            }
        };
        this.addChild(this.pathNodeA);
        this.pathNodeB = new PPath(){
            {
                this.setStroke(null);
            }
        };
        this.addChild(this.pathNodeB);
        this.updateNode();
    }

    protected void updateNode() {
        this.updateShape();
        this.updatePaint();
    }

    private void updateShape() {
        Shape shape = DiatomicElectrostaticPotentialNode.createCloudShape(this.molecule.atomA, 2.5);
        Shape shape2 = DiatomicElectrostaticPotentialNode.createCloudShape(this.molecule.atomB, 2.5);
        double d = this.molecule.bond.getLength();
        Shape shape3 = new Rectangle2D.Double(0.25, 2.5 * -this.molecule.atomA.getDiameter() / 2.0, 2.5 * d / 2.0, 2.5 * this.molecule.atomA.getDiameter());
        Shape shape4 = new Rectangle2D.Double(2.5 * -d / 2.0, 2.5 * -this.molecule.atomA.getDiameter() / 2.0, 2.5 * d / 2.0, 2.5 * this.molecule.atomA.getDiameter());
        AffineTransform affineTransform = DiatomicElectrostaticPotentialNode.createTransform(this.molecule);
        shape3 = affineTransform.createTransformedShape(shape3);
        shape4 = affineTransform.createTransformedShape(shape4);
        this.pathNodeA.setPathTo(ShapeUtils.subtract(shape, shape3));
        this.pathNodeB.setPathTo(ShapeUtils.subtract(shape2, shape4));
    }

    private void updatePaint() {
        double d = this.molecule.getDeltaEN();
        if (d == 0.0) {
            Color color = ColorUtils.createColor(this.colors[1], 185);
            this.pathNodeA.setPaint(color);
            this.pathNodeB.setPaint(color);
        } else {
            double d2 = Math.abs(d / this.electronegativityRange.getLength());
            double d3 = this.molecule.bond.getLength() + 2.5 * this.molecule.atomA.getDiameter() / 2.0 + 2.5 * this.molecule.atomB.getDiameter() / 2.0;
            double d4 = d3 / 2.0;
            double d5 = d4 * 5.0;
            Function.LinearFunction linearFunction = new Function.LinearFunction(1.0, 0.0, d4, d5);
            double d6 = linearFunction.evaluate(d2);
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(-d6 / 2.0, 0.0);
            Point2D.Double double_3 = new Point2D.Double(d6 / 2.0, 0.0);
            AffineTransform affineTransform = DiatomicElectrostaticPotentialNode.createTransform(this.molecule);
            affineTransform.transform(double_, double_);
            affineTransform.transform(double_2, double_2);
            affineTransform.transform(double_3, double_3);
            Color color = this.colors[1];
            Color color2 = d > 0.0 ? this.colors[2] : this.colors[0];
            Color color3 = d > 0.0 ? this.colors[0] : this.colors[2];
            GradientPaint gradientPaint = new GradientPaint((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY(), ColorUtils.createColor(color2, 185), (float)((Point2D)double_).getX(), (float)((Point2D)double_).getY(), ColorUtils.createColor(color, 185));
            this.pathNodeA.setPaint(gradientPaint);
            GradientPaint gradientPaint2 = new GradientPaint((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY(), ColorUtils.createColor(color, 185), (float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY(), ColorUtils.createColor(color3, 185));
            this.pathNodeB.setPaint(gradientPaint2);
        }
    }
}

