/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.common.model.DiatomicMolecule;
import edu.colorado.phet.moleculepolarity.common.view.SurfaceNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DiatomicElectronDensityNode
extends SurfaceNode {
    private final DiatomicMolecule molecule;
    private final DoubleRange electronegativityRange;
    private final Color[] colors;
    private final PPath pathNode;

    public DiatomicElectronDensityNode(DiatomicMolecule diatomicMolecule, DoubleRange doubleRange, Color[] colorArray) {
        super(diatomicMolecule);
        assert (colorArray.length == 2);
        assert (diatomicMolecule.atomA.getDiameter() == diatomicMolecule.atomB.getDiameter());
        this.molecule = diatomicMolecule;
        this.electronegativityRange = doubleRange;
        this.colors = colorArray;
        this.pathNode = new PPath(){
            {
                this.setStroke(null);
            }
        };
        this.addChild(this.pathNode);
        this.updateNode();
    }

    protected void updateNode() {
        this.updateShape();
        this.updatePaint();
    }

    private void updateShape() {
        this.pathNode.setPathTo(ShapeUtils.add(DiatomicElectronDensityNode.createCloudShape(this.molecule.atomA, 2.5), DiatomicElectronDensityNode.createCloudShape(this.molecule.atomB, 2.5)));
    }

    private void updatePaint() {
        double d = this.molecule.getDeltaEN();
        if (d == 0.0) {
            this.pathNode.setPaint(MPColors.NEUTRAL_GRAY);
        } else {
            double d2 = Math.abs(d / this.electronegativityRange.getLength());
            double d3 = this.molecule.bond.getLength() + 2.5 * this.molecule.atomA.getDiameter() / 2.0 + 2.5 * this.molecule.atomB.getDiameter() / 2.0;
            Function.LinearFunction linearFunction = new Function.LinearFunction(1.0, 0.0, d3, d3 * 5.0);
            double d4 = linearFunction.evaluate(d2);
            Point2D.Double double_ = new Point2D.Double(-d4 / 2.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(d4 / 2.0, 0.0);
            AffineTransform affineTransform = DiatomicElectronDensityNode.createTransform(this.molecule);
            affineTransform.transform(double_, double_);
            affineTransform.transform(double_2, double_2);
            Color color = d > 0.0 ? this.colors[1] : this.colors[0];
            Color color2 = d > 0.0 ? this.colors[0] : this.colors[1];
            GradientPaint gradientPaint = new GradientPaint((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY(), ColorUtils.createColor(color, 185), (float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY(), ColorUtils.createColor(color2, 185));
            this.pathNode.setPaint(gradientPaint);
        }
    }
}

