/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.common.model.Bond;
import edu.colorado.phet.moleculepolarity.common.view.DipoleNode;

public class BondDipoleNode
extends DipoleNode {
    public BondDipoleNode(final Bond bond) {
        super(bond.dipole, MPColors.BOND_DIPOLE);
        bond.dipole.addObserver(new SimpleObserver(){

            public void update() {
                double d = BondDipoleNode.isInPhase(bond, bond.dipole.get()) ? BondDipoleNode.this.getDipoleViewLength() / 2.0 : -(BondDipoleNode.this.getDipoleViewLength() / 2.0);
                double d2 = Math.atan(d / 55.0);
                double d3 = 55.0 / Math.cos(d2);
                double d4 = bond.getAngle() - 1.5707963267948966 - d2;
                double d5 = PolarCartesianConverter.getX(d3, d4);
                double d6 = PolarCartesianConverter.getY(d3, d4);
                BondDipoleNode.this.setOffset(bond.getCenter().getX() + d5, bond.getCenter().getY() + d6);
            }
        });
    }

    private static boolean isInPhase(Bond bond, ImmutableVector2D immutableVector2D) {
        return Math.abs(bond.getAngle() - immutableVector2D.getAngle()) < 0.7853981633974483;
    }
}

