/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEventArgs;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragSequenceEventHandler;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.DiatomicMolecule;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BondCharacterNode
extends PComposite {
    private static final Font TITLE_FONT = new PhetFont(12);
    private static final Font LABEL_FONT = new PhetFont(12);
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Color TRACK_COLOR = Color.WHITE;
    private final Function.LinearFunction xOffsetFunction;

    public BondCharacterNode(DiatomicMolecule diatomicMolecule) {
        PText pText = new PText(MPStrings.BOND_CHARACTER){
            {
                this.setFont(TITLE_FONT);
                this.setTextPaint(TEXT_COLOR);
            }
        };
        PText pText2 = new PText(MPStrings.IONIC){
            {
                this.setFont(LABEL_FONT);
                this.setTextPaint(TEXT_COLOR);
            }
        };
        PText pText3 = new PText(MPStrings.COVALENT){
            {
                this.setFont(LABEL_FONT);
                this.setTextPaint(TEXT_COLOR);
            }
        };
        final PointerNode pointerNode = new PointerNode(diatomicMolecule.atomA, diatomicMolecule.atomB);
        double d = 6.0 + pText.getFullBoundsReference().getHeight() + 3.0 + pointerNode.getFullBoundsReference().getHeight();
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, 360.0, d)){
            {
                this.setPaint(TRACK_COLOR);
            }
        };
        this.addChild(pPath);
        this.addChild(pointerNode);
        this.addChild(pText);
        this.addChild(pText2);
        this.addChild(pText3);
        pPath.setOffset(0.0, 0.0);
        pText.setOffset(pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, pPath.getYOffset() + 3.0);
        pointerNode.setOffset(0.0, pText.getFullBoundsReference().getMaxY() + 3.0);
        pText3.setOffset(pPath.getFullBoundsReference().getMinX() + 4.0, pPath.getYOffset() + 3.0);
        pText2.setOffset(pPath.getFullBoundsReference().getMaxX() - pText2.getFullBoundsReference().getWidth() - 4.0, pPath.getYOffset() + 3.0);
        this.xOffsetFunction = new Function.LinearFunction(0.0, MPConstants.ELECTRONEGATIVITY_RANGE.getLength(), 10.0, 360.0 - pointerNode.getFullBoundsReference().getWidth() - 10.0);
        diatomicMolecule.bond.dipole.addObserver(new VoidFunction1<ImmutableVector2D>(){

            @Override
            public void apply(ImmutableVector2D immutableVector2D) {
                pointerNode.setOffset(BondCharacterNode.this.xOffsetFunction.evaluate(immutableVector2D.getMagnitude()), pointerNode.getYOffset());
            }
        });
        this.addInputEventListener(new SimSharingDragSequenceEventHandler(new SimSharingEventArgs("BondCharacterNode", new Function0<Parameter[]>(){

            @Override
            public Parameter[] apply() {
                return new Parameter[]{Parameter.param("interactive", false)};
            }
        })));
    }

    private static class PointerNode
    extends PComposite {
        public PointerNode(Atom atom, Atom atom2) {
            PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, 13.0, 0.0)){
                {
                    this.setStroke(new BasicStroke(3.0f));
                    this.setStrokePaint(Color.GRAY);
                }
            };
            TinyAtomNode tinyAtomNode = new TinyAtomNode(atom, 10.0);
            TinyAtomNode tinyAtomNode2 = new TinyAtomNode(atom2, 10.0);
            this.addChild(pPath);
            this.addChild(tinyAtomNode);
            this.addChild(tinyAtomNode2);
            pPath.setOffset(tinyAtomNode.getFullBoundsReference().getCenterX(), tinyAtomNode.getFullBounds().getCenterY());
            tinyAtomNode2.setOffset(pPath.getFullBoundsReference().getMaxX() - tinyAtomNode2.getFullBoundsReference().getWidth() / 2.0, tinyAtomNode.getXOffset());
        }
    }

    private static class TinyAtomNode
    extends PPath {
        public TinyAtomNode(Atom atom, double d) {
            this.setPathTo(new Ellipse2D.Double(0.0, 0.0, d, d));
            this.setPaint(atom.getColor());
        }
    }
}

