/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class BondAngleArrowsNode
extends PComposite {
    private final Molecule2D molecule;
    private final Atom atom;
    private final PPath leftArrowNode;
    private final PPath rightArrowNode;

    public BondAngleArrowsNode(Molecule2D molecule2D, final Atom atom) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.molecule = molecule2D;
        this.atom = atom;
        this.leftArrowNode = new PPath(){
            {
                this.setPaint(atom.getColor());
                this.setStrokePaint(Color.GRAY);
            }
        };
        this.addChild(this.leftArrowNode);
        this.rightArrowNode = new PPath(){
            {
                this.setPaint(atom.getColor());
                this.setStrokePaint(Color.GRAY);
            }
        };
        this.addChild(this.rightArrowNode);
        atom.location.addObserver(new SimpleObserver(){

            public void update() {
                BondAngleArrowsNode.this.updateNode();
            }
        });
    }

    private void updateNode() {
        double d = this.atom.getDiameter() / 2.0;
        IndicatorArrow indicatorArrow = new IndicatorArrow(new Point2D.Double(-(d + 2.0), 0.0), new Point2D.Double(-(d + 2.0 + 25.0), 0.0));
        IndicatorArrow indicatorArrow2 = new IndicatorArrow(new Point2D.Double(d + 2.0, 0.0), new Point2D.Double(d + 2.0 + 25.0, 0.0));
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(this.molecule.location, this.atom.location.get());
        double d2 = immutableVector2D.getAngle() - 1.5707963267948966;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.atom.location.get().getX(), this.atom.location.get().getY());
        affineTransform.rotate(d2);
        Shape shape = affineTransform.createTransformedShape(indicatorArrow.getShape());
        Shape shape2 = affineTransform.createTransformedShape(indicatorArrow2.getShape());
        this.leftArrowNode.setPathTo(shape);
        this.rightArrowNode.setPathTo(shape2);
    }

    private static class IndicatorArrow
    extends Arrow {
        public IndicatorArrow(Point2D point2D, Point2D point2D2) {
            super(point2D, point2D2, 20.0, 20.0, 10.0);
        }
    }
}

