/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Bond;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;

public class TriatomicMolecule
extends Molecule2D {
    public final Atom atomA = new Atom(MPStrings.A, 100.0, MPColors.ATOM_A, MPConstants.ELECTRONEGATIVITY_RANGE.getMin());
    public final Atom atomB = new Atom(MPStrings.B, 100.0, MPColors.ATOM_B, MPConstants.ELECTRONEGATIVITY_RANGE.getMin() + MPConstants.ELECTRONEGATIVITY_RANGE.getLength() / 2.0);
    public final Atom atomC = new Atom(MPStrings.C, 100.0, MPColors.ATOM_C, MPConstants.ELECTRONEGATIVITY_RANGE.getMin());
    public final Bond bondAB = new Bond(this.atomA, this.atomB);
    public final Bond bondBC = new Bond(this.atomB, this.atomC);
    public final Property<Double> bondAngleA = new Property<Double>(2.356194490192345);
    public final Property<Double> bondAngleC = new Property<Double>(0.7853981633974483);

    public TriatomicMolecule(ImmutableVector2D immutableVector2D, double d) {
        super(immutableVector2D, d);
        this.initObservers();
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                TriatomicMolecule.this.updateAtomLocations();
            }
        };
        richSimpleObserver.observe(this.bondAngleA, this.bondAngleC);
    }

    public void reset() {
        super.reset();
        this.bondAngleA.reset();
        this.bondAngleC.reset();
    }

    public Atom[] getAtoms() {
        return new Atom[]{this.atomA, this.atomB, this.atomC};
    }

    protected Bond[] getBonds() {
        return new Bond[]{this.bondAB, this.bondBC};
    }

    protected void updateAtomLocations() {
        this.atomB.location.set(this.location);
        TriatomicMolecule.updateAtomLocation(this.atomA, this.bondAngleA.get(), this.location, (Double)this.angle.get());
        TriatomicMolecule.updateAtomLocation(this.atomC, this.bondAngleC.get(), this.location, (Double)this.angle.get());
    }

    private static void updateAtomLocation(Atom atom, double d, ImmutableVector2D immutableVector2D, double d2) {
        double d3 = d2 + d;
        double d4 = PolarCartesianConverter.getX(150.0, d3) + immutableVector2D.getX();
        double d5 = PolarCartesianConverter.getY(150.0, d3) + immutableVector2D.getY();
        atom.location.set(new ImmutableVector2D(d4, d5));
    }

    protected void updatePartialCharges() {
        double d = this.atomA.electronegativity.get() - this.atomB.electronegativity.get();
        double d2 = this.atomC.electronegativity.get() - this.atomB.electronegativity.get();
        this.atomA.partialCharge.set(-d);
        this.atomC.partialCharge.set(-d2);
        this.atomB.partialCharge.set(d + d2);
    }
}

