/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.chemistry.utils.ChemUtils;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;

public class Molecule3D {
    private final String symbol;
    private final String name;
    private final String resourceFilename;

    public Molecule3D(String string, String string2, String string3) {
        this.symbol = ChemUtils.toSubscript(string);
        this.name = string2;
        this.resourceFilename = string3;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        String string = "";
        PhetResources phetResources = new PhetResources("molecule-polarity");
        try {
            string = Molecule3D.readStream(phetResources.getResourceAsStream(this.resourceFilename));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    protected static String readStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            string = string + string2 + "\n";
            string2 = bufferedReader.readLine();
        }
        return string;
    }

    public static class ImportMolecule
    extends Molecule3D {
        public ImportMolecule() {
            super("Import...", "from file", "");
        }

        public String getData() {
            String string = "";
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(PhetApplication.getInstance().getPhetFrame());
            if (n == 0) {
                try {
                    string = ImportMolecule.readStream(new FileInputStream(jFileChooser.getSelectedFile()));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return string;
        }
    }
}

