/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Bond;

public abstract class Molecule2D {
    public final ImmutableVector2D location;
    public final Property<Double> angle;
    public final Property<ImmutableVector2D> dipole;
    private boolean dragging;

    protected Molecule2D(ImmutableVector2D immutableVector2D, double d) {
        this.location = immutableVector2D;
        this.angle = new Property<Double>(d);
        this.dipole = new Property<ImmutableVector2D>(new ImmutableVector2D());
        this.dragging = false;
    }

    public void reset() {
        this.angle.reset();
        for (Atom atom : this.getAtoms()) {
            atom.reset();
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    public abstract Atom[] getAtoms();

    protected abstract Bond[] getBonds();

    protected abstract void updateAtomLocations();

    protected abstract void updatePartialCharges();

    protected void updateMolecularDipole() {
        ImmutableVector2D immutableVector2D = new ImmutableVector2D();
        for (Bond bond : this.getBonds()) {
            immutableVector2D = immutableVector2D.plus(bond.dipole.get());
        }
        this.dipole.set(immutableVector2D);
    }

    protected void initObservers() {
        this.angle.addObserver(new SimpleObserver(){

            public void update() {
                Molecule2D.this.updateAtomLocations();
            }
        });
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                Molecule2D.this.updateMolecularDipole();
            }
        };
        for (Bond bond : this.getBonds()) {
            bond.dipole.addObserver(simpleObserver);
        }
        SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                Molecule2D.this.updatePartialCharges();
            }
        };
        for (Atom atom : this.getAtoms()) {
            atom.electronegativity.addObserver(simpleObserver2);
        }
    }
}

