/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.common.model.EField;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;

public abstract class MPModel2D
implements Resettable {
    private static final double MAX_RADIANS_PER_STEP = Math.toRadians(10.0);
    private static final Function.LinearFunction ANGULAR_VELOCITY_FUNCTION = new Function.LinearFunction(0.0, MPConstants.ELECTRONEGATIVITY_RANGE.getLength(), 0.0, MAX_RADIANS_PER_STEP);
    public final EField eField = new EField();
    private final Molecule2D molecule;

    protected MPModel2D(IClock iClock, final Molecule2D molecule2D) {
        this.molecule = molecule2D;
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (MPModel2D.this.eField.enabled.get().booleanValue() && !molecule2D.isDragging()) {
                    MPModel2D.this.updateMoleculeOrientation(molecule2D);
                }
            }
        });
    }

    public void reset() {
        this.eField.reset();
        this.molecule.reset();
    }

    protected Molecule2D getMolecule() {
        return this.molecule;
    }

    protected void updateMoleculeOrientation(Molecule2D molecule2D) {
        double d;
        double d2 = Math.abs(ANGULAR_VELOCITY_FUNCTION.evaluate(molecule2D.dipole.get().getMagnitude()));
        double d3 = d = MPModel2D.normalizeAngle(molecule2D.dipole.get().getAngle());
        if (d != 0.0) {
            if (d > 0.0 && d < Math.PI) {
                d3 = d - d2;
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
            } else {
                d3 = d + d2;
                if (d3 > Math.PI * 2) {
                    d3 = 0.0;
                }
            }
        }
        double d4 = d3 - d;
        molecule2D.angle.set(molecule2D.angle.get() + d4);
    }

    protected static double normalizeAngle(double d) {
        double d2 = d % (Math.PI * 2);
        if (d2 < 0.0) {
            d2 = Math.PI * 2 + d;
        }
        assert (d2 >= 0.0 && d2 <= Math.PI * 2);
        return d2;
    }
}

