/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.moleculepolarity.MPColors;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Bond;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;

public class DiatomicMolecule
extends Molecule2D {
    public final Atom atomA = new Atom(MPStrings.A, 100.0, MPColors.ATOM_A, MPConstants.ELECTRONEGATIVITY_RANGE.getMin());
    public final Atom atomB = new Atom(MPStrings.B, 100.0, MPColors.ATOM_B, MPConstants.ELECTRONEGATIVITY_RANGE.getMin() + MPConstants.ELECTRONEGATIVITY_RANGE.getLength() / 2.0);
    public final Bond bond = new Bond(this.atomA, this.atomB);

    public DiatomicMolecule(ImmutableVector2D immutableVector2D, double d) {
        super(immutableVector2D, d);
        this.initObservers();
    }

    public Atom[] getAtoms() {
        return new Atom[]{this.atomA, this.atomB};
    }

    protected Bond[] getBonds() {
        return new Bond[]{this.bond};
    }

    public double getDeltaEN() {
        return this.atomB.electronegativity.get() - this.atomA.electronegativity.get();
    }

    protected void updateAtomLocations() {
        double d = PolarCartesianConverter.getX(75.0, (Double)this.angle.get() + Math.PI) + this.location.getX();
        double d2 = PolarCartesianConverter.getY(75.0, (Double)this.angle.get() + Math.PI) + this.location.getY();
        this.atomA.location.set(new ImmutableVector2D(d, d2));
        double d3 = PolarCartesianConverter.getX(75.0, (Double)this.angle.get()) + this.location.getX();
        double d4 = PolarCartesianConverter.getY(75.0, (Double)this.angle.get()) + this.location.getY();
        this.atomB.location.set(new ImmutableVector2D(d3, d4));
    }

    protected void updatePartialCharges() {
        double d = this.atomA.electronegativity.get() - this.atomB.electronegativity.get();
        this.atomA.partialCharge.set(-d);
        this.atomB.partialCharge.set(d);
    }
}

