/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.moleculepolarity.common.model.Atom;

public class Bond {
    public final Property<ImmutableVector2D> endpoint1;
    public final Property<ImmutableVector2D> endpoint2;
    public final Property<ImmutableVector2D> dipole;

    public Bond(final Atom atom, final Atom atom2) {
        this.endpoint1 = new Property<ImmutableVector2D>(atom.location.get());
        this.endpoint2 = new Property<ImmutableVector2D>(atom2.location.get());
        this.dipole = new Property<ImmutableVector2D>(new ImmutableVector2D());
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                Bond.this.endpoint1.set(new ImmutableVector2D(atom.location.get()));
                Bond.this.endpoint2.set(new ImmutableVector2D(atom2.location.get()));
                double d = atom2.electronegativity.get() - atom.electronegativity.get();
                double d2 = Math.abs(d);
                double d3 = Bond.this.getAngle();
                if (d < 0.0) {
                    d3 += Math.PI;
                }
                Bond.this.dipole.set(ImmutableVector2D.createPolar(d2, d3));
            }
        };
        richSimpleObserver.observe(atom.location, atom2.location, atom.electronegativity, atom2.electronegativity);
    }

    public ImmutableVector2D getCenter() {
        return new ImmutableVector2D((this.endpoint1.get().getX() + this.endpoint2.get().getX()) / 2.0, (this.endpoint1.get().getY() + this.endpoint2.get().getY()) / 2.0);
    }

    public double getAngle() {
        ImmutableVector2D immutableVector2D = this.getCenter();
        return PolarCartesianConverter.getAngle(this.endpoint2.get().getX() - immutableVector2D.getX(), this.endpoint2.get().getY() - immutableVector2D.getY());
    }

    public double getLength() {
        return this.endpoint1.get().getDistance(this.endpoint2.get());
    }
}

