/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.control;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ComboBoxNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Molecule3D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeControlNode
extends PhetPNode {
    private final MoleculeComboBoxNode comboBoxNode;

    public MoleculeControlNode(ArrayList<Molecule3D> arrayList, final Property<Molecule3D> property) {
        PText pText = new PText(MessageFormat.format(MPStrings.PATTERN_0LABEL, MPStrings.MOLECULE)){
            {
                this.setFont(new PhetFont(18));
            }
        };
        this.addChild(pText);
        this.comboBoxNode = new MoleculeComboBoxNode(arrayList, property.get());
        this.addChild(this.comboBoxNode);
        double d = this.comboBoxNode.getFullBoundsReference().getHeight() - pText.getFullBoundsReference().getHeight();
        pText.setOffset(0.0, Math.max(0.0, d / 2.0));
        this.comboBoxNode.setOffset(pText.getFullBoundsReference().getMaxX() + 5.0, Math.min(0.0, d / 2.0));
        this.comboBoxNode.selectedItem.addObserver(new VoidFunction1<Molecule3D>(){

            @Override
            public void apply(Molecule3D molecule3D) {
                property.set(molecule3D);
            }
        });
        property.addObserver(new VoidFunction1<Molecule3D>(){

            @Override
            public void apply(Molecule3D molecule3D) {
                ((MoleculeControlNode)MoleculeControlNode.this).comboBoxNode.selectedItem.set(molecule3D);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoleculeComboBoxNode
    extends ComboBoxNode<Molecule3D> {
        public MoleculeComboBoxNode(ArrayList<Molecule3D> arrayList, Molecule3D molecule3D) {
            super(arrayList, molecule3D, new Function1<Molecule3D, PNode>(){

                @Override
                public PNode apply(final Molecule3D molecule3D) {
                    return new HTMLNode(){
                        {
                            this.setHTML(MessageFormat.format("{0} ({1})", molecule3D.getSymbol(), molecule3D.getName()));
                            this.setFont(new PhetFont(14));
                        }
                    };
                }
            }, "Molecule", new Function1<Molecule3D, String>(){

                @Override
                public String apply(Molecule3D molecule3D) {
                    return molecule3D.getName();
                }
            });
        }
    }
}

