/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.control;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEvents;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

public class MoleculeAngleHandler
extends PDragSequenceEventHandler {
    private final Molecule2D molecule;
    private final PNode dragNode;
    private double previousAngle;

    public MoleculeAngleHandler(Molecule2D molecule2D, PNode pNode) {
        this.molecule = molecule2D;
        this.dragNode = pNode;
    }

    public void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.molecule.setDragging(true);
        this.previousAngle = this.getAngle(pInputEvent);
        SimSharingEvents.sendEvent("moleculeAngle", "startDrag", Parameter.param("angle", this.molecule.angle.get()));
    }

    public void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        this.molecule.setDragging(false);
        SimSharingEvents.sendEvent("moleculeAngle", "endDrag", Parameter.param("angle", this.molecule.angle.get()));
    }

    public void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        double d = this.getAngle(pInputEvent);
        this.molecule.angle.set(this.molecule.angle.get() + d - this.previousAngle);
        this.previousAngle = d;
    }

    private double getAngle(PInputEvent pInputEvent) {
        return new ImmutableVector2D(this.molecule.location.toPoint2D(), pInputEvent.getPositionRelativeTo(this.dragNode.getParent())).getAngle();
    }
}

