/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.control;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.moleculepolarity.MPConstants;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MPControlPanelNode
extends PNode {
    public MPControlPanelNode(Frame frame, Resettable[] resettableArray, MPVerticalPanel ... mPVerticalPanelArray) {
        for (MPVerticalPanel mPVerticalPanel : mPVerticalPanelArray) {
            for (Component component : mPVerticalPanel.getComponents()) {
                SwingUtils.padPreferredWidthDeep(component, 5);
            }
        }
        int n = 0;
        for (MPVerticalPanel mPVerticalPanel : mPVerticalPanelArray) {
            n = (int)Math.max((double)n, mPVerticalPanel.getPreferredSize().getWidth());
        }
        Object object = null;
        for (MPVerticalPanel mPVerticalPanel : mPVerticalPanelArray) {
            mPVerticalPanel.setMinWidth(n);
            ControlPanelNode controlPanelNode = new ControlPanelNode(mPVerticalPanel);
            this.addChild(controlPanelNode);
            if (object != null) {
                controlPanelNode.setOffset(((PNode)object).getXOffset(), ((PNode)object).getFullBoundsReference().getMaxY() + 10.0);
            }
            object = controlPanelNode;
        }
        if (resettableArray != null) {
            MPResetAllButtonNode mPResetAllButtonNode = new MPResetAllButtonNode(resettableArray, frame);
            this.addChild(mPResetAllButtonNode);
            if (object != null) {
                ((PNode)mPResetAllButtonNode).setOffset(((PNode)object).getXOffset(), ((PNode)object).getFullBoundsReference().getMaxY() + 10.0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MPCheckBox
    extends PropertyCheckBox {
        public MPCheckBox(String string, Property<Boolean> property) {
            super(string, property);
            this.setFont(MPConstants.CONTROL_FONT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MPCheckBoxWithIcon
    extends JPanel {
        public MPCheckBoxWithIcon(String string, Icon icon, Property<Boolean> property) {
            super(new FlowLayout(0, 0, 0));
            final MPCheckBox mPCheckBox = new MPCheckBox(string, property);
            JLabel jLabel = new JLabel(icon){
                {
                    super(icon);
                    this.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent mouseEvent) {
                            mPCheckBox.setSelected(!mPCheckBox.isSelected());
                        }
                    });
                }
            };
            this.add(mPCheckBox);
            this.add(jLabel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MPRadioButton<T>
    extends PropertyRadioButton<T> {
        public MPRadioButton(String string, Property<T> property, T t) {
            super(string, property, t);
            super.setFont(MPConstants.CONTROL_FONT);
        }
    }

    public class MPResetAllButtonNode
    extends ResetAllButtonNode {
        public MPResetAllButtonNode(Resettable[] resettableArray, Frame frame) {
            super(resettableArray, (Component)frame, 16, Color.BLACK, Color.WHITE);
            this.setConfirmationEnabled(false);
        }
    }

    public static abstract class MPVerticalPanel
    extends GridPanel {
        public MPVerticalPanel(String string) {
            this.setGridX(0);
            this.setAnchor(GridPanel.Anchor.WEST);
            this.add(new JLabel(string){
                {
                    this.setFont(MPConstants.TITLE_FONT);
                }
            });
            this.add(Box.createVerticalStrut(5));
        }

        public void setMinWidth(int n) {
            this.add(Box.createHorizontalStrut(n));
        }
    }
}

