/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.control;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEventArgs;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.model.Atom;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;

public class ElectronegativityControlNode
extends PhetPNode {
    private static final PDimension TRACK_SIZE = new PDimension(125.0, 5.0);
    private static final Color TRACK_FILL_COLOR = Color.LIGHT_GRAY;
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final PDimension THUMB_SIZE = new PDimension(15.0, 20.0);
    private static final Stroke THUMB_STROKE = new BasicStroke(1.0f);
    private static final Color THUMB_STROKE_COLOR = Color.BLACK;
    private static final Color THUMB_HIGHLIGHT_COLOR = Color.GREEN;
    private static final Color THUMB_NORMAL_COLOR = THUMB_HIGHLIGHT_COLOR.darker();
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(2.0f);
    private static final Color BACKGROUND_STROKE_COLOR = Color.GRAY;

    public ElectronegativityControlNode(Atom atom, Molecule2D molecule2D, DoubleRange doubleRange, double d) {
        final PanelNode panelNode = new PanelNode(atom, molecule2D, doubleRange, d);
        String string = MessageFormat.format(MPStrings.PATTERN_0ATOM_NAME, atom.getName());
        TitledBackgroundNode titledBackgroundNode = new TitledBackgroundNode(string, atom.getColor(), panelNode, 10.0, 5.0);
        this.addChild(titledBackgroundNode);
        atom.electronegativity.addObserver(new SimpleObserver(){

            public void update() {
                panelNode.updateControl();
            }
        });
    }

    private static class MajorTickMarkNode
    extends TickMarkNode {
        public MajorTickMarkNode() {
            this(null);
        }

        public MajorTickMarkNode(String string) {
            super(12.0, MAJOR_TICK_STROKE, string);
        }
    }

    private static class MinorTickMarkNode
    extends TickMarkNode {
        public MinorTickMarkNode() {
            super(7.0, MINOR_TICK_STROKE, null);
        }
    }

    private static class PanelNode
    extends PhetPNode {
        private final Atom atom;
        private final TrackNode trackNode;
        private final ThumbNode thumbNode;
        private final DoubleRange range;

        public PanelNode(Atom atom, Molecule2D molecule2D, DoubleRange doubleRange, double d) {
            this.atom = atom;
            this.range = doubleRange;
            this.trackNode = new TrackNode();
            this.addChild(this.trackNode);
            this.trackNode.setOffset(0.0, 0.0);
            PText pText = new PText(MPStrings.ELECTRONEGATIVITY){
                {
                    this.setFont(new PhetFont(14));
                }
            };
            this.addChild(pText);
            pText.setOffset(this.trackNode.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, this.trackNode.getFullBoundsReference().getMinY() - pText.getFullBoundsReference().getHeight() - 15.0);
            int n = (int)(doubleRange.getLength() / d) + 1;
            double d2 = TRACK_SIZE.getWidth() / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                TickMarkNode tickMarkNode = i == 0 ? new MajorTickMarkNode(MPStrings.LESS) : (i == n - 1 ? new MajorTickMarkNode(MPStrings.MORE) : ((double)i * d % 1.0 == 0.0 ? new MajorTickMarkNode() : new MinorTickMarkNode()));
                this.addChild(tickMarkNode);
                tickMarkNode.setOffset(this.trackNode.getXOffset() + (double)i * d2, this.trackNode.getFullBoundsReference().getMaxY());
            }
            this.thumbNode = new ThumbNode(molecule2D, this, this.trackNode, doubleRange, d, atom);
            this.addChild(this.thumbNode);
            this.thumbNode.setOffset(this.trackNode.getFullBoundsReference().getCenterX(), this.trackNode.getFullBoundsReference().getCenterY() + this.thumbNode.getFullBoundsReference().getHeight() / 3.0);
            atom.electronegativity.addObserver(new SimpleObserver(){

                public void update() {
                    PanelNode.this.updateControl();
                }
            });
        }

        public void updateControl() {
            Function.LinearFunction linearFunction = new Function.LinearFunction(this.range.getMin(), this.range.getMax(), this.trackNode.getXOffset(), this.trackNode.getXOffset() + TRACK_SIZE.getWidth());
            double d = linearFunction.evaluate(this.atom.electronegativity.get());
            double d2 = this.thumbNode.getYOffset();
            this.thumbNode.setOffset(d, d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbDragHandler
    extends SliderThumbDragHandler {
        private final Molecule2D molecule;
        private final double snapInterval;

        public ThumbDragHandler(Molecule2D molecule2D, PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, double d, VoidFunction1<Double> voidFunction1) {
            super(SliderThumbDragHandler.Orientation.HORIZONTAL, pNode, pNode2, pNode3, doubleRange, voidFunction1);
            this.molecule = molecule2D;
            this.snapInterval = d;
        }

        @Override
        protected double adjustValue(double d) {
            return Math.floor(d / this.snapInterval + 0.5) * this.snapInterval;
        }

        @Override
        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            this.molecule.setDragging(true);
        }

        @Override
        protected void endDrag(PInputEvent pInputEvent) {
            super.endDrag(pInputEvent);
            this.molecule.setDragging(false);
        }
    }

    private static class ThumbNode
    extends PPath {
        public ThumbNode(Molecule2D molecule2D, PNode pNode, PNode pNode2, DoubleRange doubleRange, double d, final Atom atom) {
            float f = (float)THUMB_SIZE.getWidth();
            float f2 = (float)THUMB_SIZE.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(f / 2.0f, 0.35f * -f2);
            generalPath.lineTo(f / 2.0f, -f2);
            generalPath.lineTo(-f / 2.0f, -f2);
            generalPath.lineTo(-f / 2.0f, 0.35f * -f2);
            generalPath.closePath();
            this.setPathTo(generalPath);
            this.setPaint(THUMB_NORMAL_COLOR);
            this.setStroke(THUMB_STROKE);
            this.setStrokePaint(THUMB_STROKE_COLOR);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(this, THUMB_NORMAL_COLOR, THUMB_HIGHLIGHT_COLOR));
            this.addInputEventListener(new ThumbDragHandler(molecule2D, pNode, pNode2, this, doubleRange, d, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    atom.electronegativity.set(d);
                }
            }){
                {
                    super(molecule2D, pNode, pNode2, pNode3, doubleRange, d, voidFunction1);
                    this.setSimSharingEventArgs(new SimSharingEventArgs("electronegativityControl", new Function0<Parameter[]>(){

                        @Override
                        public Parameter[] apply() {
                            return new Parameter[]{Parameter.param("atom", atom.getName()), Parameter.param("electronegativity", atom.electronegativity.get())};
                        }
                    }));
                }
            });
        }
    }

    private static abstract class TickMarkNode
    extends PComposite {
        public TickMarkNode(double d, final Stroke stroke, String string) {
            PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, 0.0, d)){
                {
                    super(shape);
                    this.setStroke(stroke);
                }
            };
            this.addChild(pPath);
            if (string != null && string.trim().length() != 0) {
                PText pText = new PText(string){
                    {
                        this.setFont(new PhetFont(12));
                    }
                };
                this.addChild(pText);
                double d2 = pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0;
                double d3 = pPath.getFullBoundsReference().getMaxY() + 2.0;
                pText.setOffset(d2, d3);
            }
        }
    }

    private static class TitledBackgroundNode
    extends PhetPNode {
        public TitledBackgroundNode(String string, final Color color, PNode pNode, double d, double d2) {
            PText pText = new PText(string){
                {
                    this.setFont(new PhetFont(20));
                }
            };
            double d3 = Math.max(pText.getFullBoundsReference().getWidth(), pNode.getFullBoundsReference().getWidth()) + 2.0 * d;
            double d4 = pText.getFullBoundsReference().getHeight() / 2.0 + pNode.getFullBoundsReference().getHeight() + 10.0;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d3, d4, 10.0, 10.0);
            double d5 = d3 / 2.0 - pText.getFullBoundsReference().getWidth() / 2.0 - d;
            double d6 = -(pText.getFullBoundsReference().getHeight() / 2.0) - d2;
            double d7 = pText.getFullBoundsReference().getWidth() + 2.0 * d;
            double d8 = pText.getFullBoundsReference().getHeight() + 2.0 * d2;
            RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(d5, d6, d7, d8, 10.0, 10.0);
            Area area = new Area(double_);
            area.add(new Area(double_2));
            PPath pPath = new PPath(area){
                {
                    super(shape);
                    this.setStroke(BACKGROUND_STROKE);
                    this.setStrokePaint(BACKGROUND_STROKE_COLOR);
                    this.setPaint(color);
                }
            };
            this.addChild(pPath);
            this.addChild(pNode);
            this.addChild(pText);
            double d9 = d3 / 2.0 - pNode.getFullBoundsReference().getWidth() / 2.0 - PNodeLayoutUtils.getOriginXOffset(pNode);
            double d10 = -PNodeLayoutUtils.getOriginYOffset(pNode) + pText.getFullBoundsReference().getHeight() / 2.0;
            pNode.setOffset(d9, d10);
            d9 = d3 / 2.0 - pText.getFullBoundsReference().getWidth() / 2.0;
            d10 = -(pText.getFullBoundsReference().getHeight() / 2.0);
            pText.setOffset(d9, d10);
        }
    }

    private static class TrackNode
    extends PPath {
        public TrackNode() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, TRACK_SIZE.width, TRACK_SIZE.height));
            this.setPaint(TRACK_FILL_COLOR);
            this.setStrokePaint(TRACK_STROKE_COLOR);
            this.setStroke(TRACK_STROKE);
        }
    }
}

