/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity.common.control;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEvents;
import edu.colorado.phet.moleculepolarity.common.model.Molecule2D;
import edu.colorado.phet.moleculepolarity.common.view.AtomNode;
import edu.colorado.phet.moleculepolarity.common.view.BondAngleArrowsNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BondAngleHandler
extends PDragSequenceEventHandler {
    private final Molecule2D molecule;
    private final Property<Double> bondAngle;
    private final AtomNode atomNode;
    private final BondAngleArrowsNode arrowsNode;
    private double previousAngle;

    public BondAngleHandler(Molecule2D molecule2D, Property<Double> property, AtomNode atomNode, BondAngleArrowsNode bondAngleArrowsNode) {
        this.molecule = molecule2D;
        this.bondAngle = property;
        this.atomNode = atomNode;
        this.arrowsNode = bondAngleArrowsNode;
    }

    @Override
    public void mouseEntered(PInputEvent pInputEvent) {
        super.mouseEntered(pInputEvent);
        this.atomNode.moveToFront();
        this.arrowsNode.moveInBackOf(this.atomNode);
        if ((pInputEvent.getModifiersEx() & 0x400) != 1024) {
            this.arrowsNode.setVisible(true);
        }
    }

    @Override
    public void mouseExited(PInputEvent pInputEvent) {
        this.arrowsNode.setVisible(false);
    }

    @Override
    public void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.molecule.setDragging(true);
        this.previousAngle = this.getAngle(pInputEvent);
        this.arrowsNode.setVisible(false);
        SimSharingEvents.sendEvent("bondAngle", "startDrag", Parameter.param("atom", this.atomNode.atom.getName()), Parameter.param("angle", this.bondAngle.get()));
    }

    @Override
    public void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        double d = this.getAngle(pInputEvent);
        this.bondAngle.set(this.bondAngle.get() + d - this.previousAngle);
        this.previousAngle = d;
    }

    @Override
    public void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        this.molecule.setDragging(false);
        SimSharingEvents.sendEvent("bondAngle", "endDrag", Parameter.param("atom", this.atomNode.atom.getName()), Parameter.param("angle", this.bondAngle.get()));
    }

    private double getAngle(PInputEvent pInputEvent) {
        return new ImmutableVector2D(this.molecule.location.toPoint2D(), pInputEvent.getPositionRelativeTo(this.atomNode.getParent())).getAngle();
    }
}

