/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculepolarity;

import edu.colorado.phet.common.jmolphet.JmolConsole;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.DialogCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.moleculepolarity.MPStrings;
import edu.colorado.phet.moleculepolarity.common.view.JmolViewerNode;
import edu.colorado.phet.moleculepolarity.realmolecules.RealMoleculesModule;
import edu.colorado.phet.moleculepolarity.threeatoms.ThreeAtomsModule;
import edu.colorado.phet.moleculepolarity.twoatoms.TwoAtomsModule;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;

public class MoleculePolarityApplication
extends PiccoloPhetApplication {
    public MoleculePolarityApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        PhetFrame phetFrame = this.getPhetFrame();
        this.addModule(new TwoAtomsModule(phetFrame));
        this.addModule(new ThreeAtomsModule(phetFrame));
        final RealMoleculesModule realMoleculesModule = new RealMoleculesModule(phetFrame);
        this.addModule(realMoleculesModule);
        phetFrame.addMenu(new OptionsMenu(){
            {
                this.add(new SimSharingJCheckBoxMenuItem(MPStrings.RAINBOW_OPTION, (boolean)JmolViewerNode.RAINBOW_MEP.get()){
                    {
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JmolViewerNode.RAINBOW_MEP.set(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                            }
                        });
                    }
                });
            }
        });
        phetFrame.getDeveloperMenu().add(new DialogCheckBoxMenuItem("Jmol Console...", "Jmol Console", this.getPhetFrame(), new Function0<Container>(){

            @Override
            public Container apply() {
                return new JmolConsole(realMoleculesModule.getJmolViewer());
            }
        }));
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "molecule-polarity", MoleculePolarityApplication.class);
    }
}

