/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.menu;

import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private final Frame parent;
    private final String dialogTitle;
    private final Function0<Container> createDialogContentPane;
    private JDialog dialog;

    public DialogCheckBoxMenuItem(String string, String string2, Frame frame, Function0<Container> function0) {
        super(string);
        this.parent = frame;
        this.dialogTitle = string2;
        this.createDialogContentPane = function0;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogCheckBoxMenuItem.this.isSelected()) {
                    DialogCheckBoxMenuItem.this.openDialog();
                } else {
                    DialogCheckBoxMenuItem.this.closeDialog();
                }
            }
        });
    }

    protected void openDialog() {
        if (this.dialog != null) {
            this.closeDialog();
        }
        this.dialog = new JDialog(this.parent){
            {
                this.setTitle(DialogCheckBoxMenuItem.this.dialogTitle);
                this.setContentPane((Container)DialogCheckBoxMenuItem.this.createDialogContentPane.apply());
                this.pack();
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        DialogCheckBoxMenuItem.this.closeDialog();
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        DialogCheckBoxMenuItem.this.closeDialog();
                        if (DialogCheckBoxMenuItem.this.isSelected()) {
                            DialogCheckBoxMenuItem.this.setSelected(false);
                        }
                    }
                });
            }
        };
        SwingUtils.centerInParent(this.dialog);
        this.dialog.setVisible(true);
    }

    protected void closeDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

