/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingEvents;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Component;
import java.util.Vector;

public class ResetAllDelegate {
    private final Vector<Resettable> resettables = new Vector();
    private final Component parent;
    private boolean confirmationEnabled;

    public ResetAllDelegate(Resettable[] resettableArray, Component component) {
        for (Resettable resettable : resettableArray) {
            this.resettables.add(resettable);
        }
        this.parent = component;
        this.confirmationEnabled = true;
    }

    public void setConfirmationEnabled(boolean bl) {
        this.confirmationEnabled = bl;
    }

    public void resetAll() {
        if (!this.confirmationEnabled || this.confirmReset()) {
            for (Resettable resettable : this.resettables) {
                resettable.reset();
            }
        }
    }

    private boolean confirmReset() {
        SimSharingEvents.sendSystemEvent("reset all confirmation dialog shown", new Parameter[0]);
        String string = PhetCommonResources.getInstance().getLocalizedString("ControlPanel.message.confirmResetAll");
        String string2 = PhetCommonResources.getInstance().getLocalizedString("Common.title.confirm");
        int n = PhetOptionPane.showYesNoDialog(this.parent, string, string2);
        boolean bl = n == 0;
        SimSharingEvents.sendEvent("resetAllConfirmationDialog", "userSelectedOption", Parameter.param("shouldReset", bl));
        return bl;
    }
}

