/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetPersistenceDir;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.IActor;
import edu.colorado.phet.common.phetcommon.simsharing.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.StringActor;
import edu.colorado.phet.common.phetcommon.simsharing.ThreadedActor;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.Option;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class SimSharingEvents {
    private static final Logger LOGGER = Logger.getLogger(SimSharingEvents.class.getCanonicalName());
    public static final String SESSION_ID = SimSharingEvents.generateIDString();
    public static String MACHINE_COOKIE;
    private static boolean printedColumns;
    private static IActor client;
    private static boolean enabled;
    private static Option<Long> simStartedTime;
    private static Collection<String> queue;
    public static Property<String> log;
    public static int messageCount;
    private static String studyName;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void sendSystemEvent(String string, Parameter ... parameterArray) {
        SimSharingEvents.sendEvent("system", string, parameterArray);
    }

    public static String sendEvent(String string, String string2, Parameter ... parameterArray) {
        if (enabled) {
            if (!printedColumns) {
                System.out.println("machineID = " + MACHINE_COOKIE);
                System.out.println("sessionID = " + SESSION_ID);
                System.out.println("serverTime = " + System.currentTimeMillis());
                printedColumns = true;
            }
            String string3 = simStartedTime.isSome() ? System.currentTimeMillis() - simStartedTime.get() + "" : "@" + System.currentTimeMillis();
            String string4 = new ObservableList<Parameter>(parameterArray).mkString("\t");
            String string5 = string3 + "\t" + string + "\t" + string2 + "\t" + string4;
            System.out.println(string5);
            log.set(log.get() + "\n" + string5);
            SimSharingEvents.deliverMessage(MACHINE_COOKIE + "\t" + SESSION_ID + "\t" + string3 + "\t" + string + "\t" + string2 + "\t" + string4);
            if (++messageCount % 100 == 0 && messageCount > 0) {
                SimSharingEvents.sendSystemEvent("messageCount", Parameter.param("messageCount", messageCount));
            }
            return string5;
        }
        return null;
    }

    private static void deliverMessage(String string) {
        boolean bl;
        boolean bl2 = enabled;
        boolean bl3 = bl = client != null;
        if (bl2 && bl) {
            SimSharingEvents.tellWithErrorHandling(string);
        } else if (bl2 && !bl) {
            queue.add(string);
        }
    }

    private static void tellWithErrorHandling(String string) {
        try {
            client.tell(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void simStarted(PhetApplicationConfig phetApplicationConfig) {
        simStartedTime = new Option.Some<Long>(System.currentTimeMillis());
        enabled = phetApplicationConfig.isSimSharingEnabled();
        if (enabled) {
            studyName = SimSharingEvents.getArgAfter(phetApplicationConfig.getCommandLineArgs(), "-study");
            String string = JOptionPane.showInputDialog(null, (Object)(studyName.equals("colorado") ? "Welcome to PhET!\nEnter your computer number:" : "Enter your audio recorder number:"));
            SimSharingEvents.finishInit(phetApplicationConfig, studyName, string);
        }
    }

    private static void finishInit(final PhetApplicationConfig phetApplicationConfig, final String string, final String string2) {
        try {
            MACHINE_COOKIE = SimSharingEvents.getMachineID();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    client = new ThreadedActor<String, String>(new StringActor());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (EOFException eOFException) {
                    LOGGER.severe("Reached the end of the DataInputStream before reading 2 bytes. Is the sim-sharing server running?");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                SimSharingEvents.sendSystemEvent("started", Parameter.param("time", (Long)simStartedTime.get()), Parameter.param("name", phetApplicationConfig.getName()), Parameter.param("version", phetApplicationConfig.getVersion().formatForAboutDialog()), Parameter.param("project", phetApplicationConfig.getProjectName()), Parameter.param("flavor", phetApplicationConfig.getFlavor()), Parameter.param("locale", phetApplicationConfig.getLocale().toString()), Parameter.param("distributionTag", phetApplicationConfig.getDistributionTag()), Parameter.param("javaVersion", System.getProperty("java.version")), Parameter.param("osName", System.getProperty("os.name")), Parameter.param("osVersion", System.getProperty("os.version")), Parameter.param("parserVersion", 1L), Parameter.param("study", string), Parameter.param("id", string2));
                SimSharingEvents.sendSystemEvent("connected to server", new Parameter[0]);
                if (client != null) {
                    SimSharingEvents.deliverQueue();
                } else {
                    LOGGER.warning("Weren't able to connect to the server even though we really wanted to.");
                }
            }
        }).start();
    }

    private static String getArgAfter(String[] stringArray, String string) {
        int n = Arrays.asList(stringArray).indexOf(string);
        if (n >= 0 && n <= stringArray.length - 2 && !stringArray[n + 1].startsWith("-")) {
            return stringArray[n + 1];
        }
        return "?";
    }

    private static String getMachineID() throws IOException {
        PhetPersistenceDir phetPersistenceDir = new PhetPersistenceDir();
        boolean bl = phetPersistenceDir.mkdirs();
        final File file = new File(phetPersistenceDir, "sim-sharing.properties");
        if (file.exists()) {
            Properties properties = new Properties(){
                {
                    this.load(new FileInputStream(file));
                }
            };
            return properties.getProperty("machine.cookie");
        }
        Properties properties = new Properties(){

            @Override
            public Set<Object> keySet() {
                return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
            }

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        String string = SimSharingEvents.generateIDString();
        properties.put("machine.cookie", string);
        properties.store(new FileOutputStream(file), "Automatically generated by " + SimSharingEvents.class.getName());
        return string;
    }

    private static synchronized void deliverQueue() {
        for (String string : queue) {
            SimSharingEvents.tellWithErrorHandling(string);
        }
        queue.clear();
    }

    private static String generateIDString() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    static {
        enabled = false;
        simStartedTime = new Option.None<Long>();
        queue = Collections.synchronizedCollection(new ArrayList());
        log = new Property<String>("");
        messageCount = 0;
    }
}

