/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.molarity.model.Solution;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

class SolutionNode
extends PComposite {
    private final PDimension cylinderSize;
    private final double cylinderEndHeight;
    private final Solution solution;
    private final Function.LinearFunction volumeFunction;
    private final PPath cylinderNode;
    private final PPath topNode;

    public SolutionNode(PDimension pDimension, double d, Solution solution, double d2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.cylinderSize = pDimension;
        this.cylinderEndHeight = d;
        this.solution = solution;
        this.volumeFunction = new Function.LinearFunction(0.0, d2, 0.0, pDimension.getHeight());
        this.cylinderNode = new PPath(){
            {
                this.setStroke(null);
            }
        };
        this.topNode = new PPath(){
            {
                this.setStroke(new BasicStroke(0.5f));
                this.setStrokePaint(new Color(0, 0, 0, 85));
            }
        };
        this.addChild(this.cylinderNode);
        this.addChild(this.topNode);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                SolutionNode.this.updateNode();
            }
        };
        richSimpleObserver.observe(solution.concentration, solution.solute, solution.volume);
    }

    private void updateNode() {
        Color color = this.solution.solvent.color;
        if (this.solution.concentration.get() > 0.0) {
            Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, this.solution.getSaturatedConcentration(), 0.0, 1.0);
            double d = linearFunction.evaluate(this.solution.concentration.get());
            color = this.solution.solute.get().solutionColor.interpolateLinear(d);
        }
        this.cylinderNode.setPaint(color);
        this.topNode.setPaint(color);
        double d = this.volumeFunction.evaluate(this.solution.volume.get());
        this.cylinderNode.setPathTo(this.createCylinderShape(d));
        this.topNode.setPathTo(this.createTopShape(d));
    }

    private Shape createCylinderShape(double d) {
        Shape shape;
        if (d == 0.0) {
            shape = new GeneralPath();
        } else {
            Area area = new Area(new Rectangle2D.Double(0.0, this.cylinderSize.getHeight() - d, this.cylinderSize.getWidth(), d));
            area.add(new Area(new Ellipse2D.Double(0.0, this.cylinderSize.getHeight() - d - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight)));
            area.add(new Area(new Ellipse2D.Double(0.0, this.cylinderSize.getHeight() - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight)));
            shape = area;
        }
        return shape;
    }

    private Shape createTopShape(double d) {
        if (d == 0.0) {
            return new GeneralPath();
        }
        return new Ellipse2D.Double(0.0, this.cylinderSize.getHeight() - d - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight);
    }
}

