/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.model.Solution;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;

class SaturatedIndicatorNode
extends PComposite {
    public SaturatedIndicatorNode(final Solution solution) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        PText pText = new PText(MolarityResources.Strings.SATURATED){
            {
                this.setFont(new PhetFont(20));
            }
        };
        double d = 1.2 * pText.getFullBoundsReference().getWidth();
        double d2 = 1.2 * pText.getFullBoundsReference().getHeight();
        PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, d2, 8.0, 8.0)){
            {
                this.setPaint(ColorUtils.createColor(Color.WHITE, 150));
                this.setStroke(null);
            }
        };
        this.addChild(pPath);
        this.addChild(pText);
        pText.setOffset(pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, pPath.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0);
        solution.precipitateAmount.addObserver(new SimpleObserver(){

            public void update() {
                SaturatedIndicatorNode.this.setVisible(solution.isSaturated());
            }
        });
    }
}

