/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.molarity.model.Solution;
import edu.colorado.phet.molarity.view.PrecipitateParticleNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;

class PrecipitateNode
extends PComposite {
    private final Solution solution;
    private final PDimension cylinderSize;
    private final double cylinderEndHeight;
    private final ArrayList<PrecipitateParticleNode> particleNodes;
    private final PText valueNode;

    public PrecipitateNode(Solution solution, PDimension pDimension, double d) {
        this.solution = solution;
        this.cylinderSize = pDimension;
        this.cylinderEndHeight = d;
        this.particleNodes = new ArrayList();
        this.valueNode = new PText("?"){
            {
                this.setFont(new PhetFont(12));
            }
        };
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(this.valueNode);
        }
        solution.precipitateAmount.addObserver(new SimpleObserver(){

            public void update() {
                PrecipitateNode.this.updateParticles();
                PrecipitateNode.this.updateValue();
            }
        });
        solution.solute.addObserver(new SimpleObserver(){

            public void update() {
                PrecipitateNode.this.removeAllParticles();
                PrecipitateNode.this.updateParticles();
                PrecipitateNode.this.updateValue();
            }
        });
        this.valueNode.setOffset((pDimension.getWidth() - this.valueNode.getFullBoundsReference().getWidth()) / 2.0, pDimension.getHeight() + d);
    }

    private void removeAllParticles() {
        for (PrecipitateParticleNode precipitateParticleNode : this.particleNodes) {
            this.removeChild(precipitateParticleNode);
        }
        this.particleNodes.clear();
    }

    private void updateParticles() {
        int n = this.getNumberOfParticles();
        if (n == 0) {
            this.removeAllParticles();
        } else if (n > this.particleNodes.size()) {
            while (n > this.particleNodes.size()) {
                PrecipitateParticleNode precipitateParticleNode = new PrecipitateParticleNode(this.solution.solute.get());
                this.addChild(precipitateParticleNode);
                this.particleNodes.add(precipitateParticleNode);
                precipitateParticleNode.setOffset(this.getRandomOffset(precipitateParticleNode));
            }
        } else {
            while (n < this.particleNodes.size()) {
                PrecipitateParticleNode precipitateParticleNode = this.particleNodes.get(this.particleNodes.size() - 1);
                this.removeChild(precipitateParticleNode);
                this.particleNodes.remove(precipitateParticleNode);
            }
        }
    }

    private void updateValue() {
        double d = this.solution.precipitateAmount.get();
        int n = this.getNumberOfParticles();
        this.valueNode.setText("dev: precipitate = " + new DecimalFormat("0.00000").format(d) + " mol, " + n + " particles");
    }

    private int getNumberOfParticles() {
        int n = (int)((double)this.solution.solute.get().particlesPerMole * this.solution.precipitateAmount.get());
        if (n == 0 && this.solution.precipitateAmount.get() > 0.0) {
            n = 1;
        }
        return n;
    }

    protected Point2D getRandomOffset(PrecipitateParticleNode precipitateParticleNode) {
        double d = precipitateParticleNode.getFullBoundsReference().getWidth();
        double d2 = precipitateParticleNode.getFullBoundsReference().getHeight();
        double d3 = Math.random() * 2.0 * Math.PI;
        Point2D point2D = PrecipitateNode.getRandomPointInsideEllipse(d3, this.cylinderSize.getWidth() - 2.0 * d, this.cylinderEndHeight - 2.0 * d2);
        double d4 = this.cylinderSize.getWidth() / 2.0 + point2D.getX();
        double d5 = this.cylinderSize.getHeight() - point2D.getY() - d2 / 2.0;
        return new Point2D.Double(d4, d5);
    }

    private static Point2D getRandomPointInsideEllipse(double d, double d2, double d3) {
        double d4 = Math.sqrt(Math.random()) * Math.cos(d);
        double d5 = Math.sqrt(Math.random()) * Math.sin(d);
        return new Point2D.Double(d4 * d2 / 2.0, d5 * d3 / 2.0);
    }
}

