/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySimSharing;
import edu.colorado.phet.molarity.control.ShowValuesNode;
import edu.colorado.phet.molarity.control.SoluteControlNode;
import edu.colorado.phet.molarity.control.VerticalSliderNode;
import edu.colorado.phet.molarity.model.MolarityModel;
import edu.colorado.phet.molarity.view.AbstractMolarityCanvas;
import edu.colorado.phet.molarity.view.BeakerNode;
import edu.colorado.phet.molarity.view.ConcentrationDisplayNode;
import edu.colorado.phet.molarity.view.PrecipitateNode;
import edu.colorado.phet.molarity.view.SaturatedIndicatorNode;
import edu.colorado.phet.molarity.view.SolutionNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Frame;
import java.text.MessageFormat;

public class MolarityCanvas
extends AbstractMolarityCanvas {
    private final Property<Boolean> valuesVisible = new Property<Boolean>(false);

    public MolarityCanvas(MolarityModel molarityModel, Frame frame) {
        BeakerNode beakerNode = new BeakerNode(MolaritySimSharing.UserComponents.solutionBeaker, molarityModel.solution, molarityModel.getSolutionVolumeRange().getMax(), MolarityResources.Strings.UNITS__LITERS, MolarityResources.Strings.UNITS__MOLARITY, new PhetFont(1, 28), new PhetFont(16), new PDimension(180.0, 80.0), 0.75, 0.75, this.valuesVisible);
        PDimension pDimension = beakerNode.getCylinderSize();
        SolutionNode solutionNode = new SolutionNode(pDimension, beakerNode.getCylinderEndHeight(), molarityModel.solution, molarityModel.getSolutionVolumeRange().getMax());
        PrecipitateNode precipitateNode = new PrecipitateNode(molarityModel.solution, pDimension, beakerNode.getCylinderEndHeight());
        SaturatedIndicatorNode saturatedIndicatorNode = new SaturatedIndicatorNode(molarityModel.solution);
        SoluteControlNode soluteControlNode = new SoluteControlNode(molarityModel.getSolutes(), molarityModel.solution.solute);
        VerticalSliderNode verticalSliderNode = new VerticalSliderNode(MolaritySimSharing.UserComponents.soluteAmountSlider, MolarityResources.Strings.SOLUTE_AMOUNT, MessageFormat.format(MolarityResources.Strings.PATTERN__PARENTHESES__0TEXT, MolarityResources.Strings.MOLES), MolarityResources.Strings.NONE, MolarityResources.Strings.LOTS, new PDimension(5.0, pDimension.getHeight()), molarityModel.solution.soluteAmount, molarityModel.getSoluteAmountRange(), MolarityResources.Strings.UNITS__MOLES, this.valuesVisible);
        double d = molarityModel.getSolutionVolumeRange().getLength() / molarityModel.getSolutionVolumeRange().getMax() * pDimension.getHeight();
        VerticalSliderNode verticalSliderNode2 = new VerticalSliderNode(MolaritySimSharing.UserComponents.volumeSlider, MolarityResources.Strings.SOLUTION_VOLUME, MessageFormat.format(MolarityResources.Strings.PATTERN__PARENTHESES__0TEXT, MolarityResources.Strings.LITERS), MolarityResources.Strings.LOW, MolarityResources.Strings.FULL, new PDimension(5.0, d), molarityModel.solution.volume, molarityModel.getSolutionVolumeRange(), MolarityResources.Strings.UNITS__LITERS, this.valuesVisible);
        PDimension pDimension2 = new PDimension(40.0, pDimension.getHeight() + 50.0);
        ConcentrationDisplayNode concentrationDisplayNode = new ConcentrationDisplayNode(MolarityResources.Strings.SOLUTION_CONCENTRATION, MessageFormat.format(MolarityResources.Strings.PATTERN__PARENTHESES__0TEXT, MolarityResources.Strings.MOLARITY), pDimension2, molarityModel.solution, molarityModel.getConcentrationDisplayRange(), MolarityResources.Strings.UNITS__MOLARITY, MolarityResources.Strings.ZERO, MolarityResources.Strings.HIGH, this.valuesVisible);
        ShowValuesNode showValuesNode = new ShowValuesNode(this.valuesVisible);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{this, molarityModel}, frame, 18, Color.BLACK, new Color(235, 235, 235)){
            {
                this.setConfirmationEnabled(false);
            }
        };
        this.addChild(solutionNode);
        this.addChild(beakerNode);
        this.addChild(precipitateNode);
        this.addChild(saturatedIndicatorNode);
        this.addChild(concentrationDisplayNode);
        this.addChild(verticalSliderNode);
        this.addChild(verticalSliderNode2);
        this.addChild(showValuesNode);
        this.addChild(resetAllButtonNode);
        this.addChild(soluteControlNode);
        soluteControlNode.setOffset(0.0, 0.0);
        verticalSliderNode.setOffset(soluteControlNode.getXOffset() - PNodeLayoutUtils.getOriginXOffset(verticalSliderNode), soluteControlNode.getFullBoundsReference().getMaxY() - PNodeLayoutUtils.getOriginYOffset(beakerNode) + 40.0);
        verticalSliderNode2.setOffset(verticalSliderNode.getFullBoundsReference().getMaxX() - PNodeLayoutUtils.getOriginXOffset(verticalSliderNode2) + 20.0, verticalSliderNode.getYOffset());
        beakerNode.setOffset(verticalSliderNode2.getFullBoundsReference().getMaxX() - PNodeLayoutUtils.getOriginXOffset(beakerNode) + 20.0, verticalSliderNode2.getYOffset());
        solutionNode.setOffset(beakerNode.getOffset());
        precipitateNode.setOffset(beakerNode.getOffset());
        saturatedIndicatorNode.setOffset(beakerNode.getXOffset() + pDimension.getWidth() / 2.0 - saturatedIndicatorNode.getFullBoundsReference().getWidth() / 2.0, beakerNode.getYOffset() + 0.9 * pDimension.getHeight() - saturatedIndicatorNode.getFullBoundsReference().getHeight());
        concentrationDisplayNode.setOffset(beakerNode.getFullBoundsReference().getMaxX() - PNodeLayoutUtils.getOriginXOffset(concentrationDisplayNode) + 50.0, beakerNode.getFullBoundsReference().getMaxY() - concentrationDisplayNode.getFullBoundsReference().getHeight() - PNodeLayoutUtils.getOriginYOffset(concentrationDisplayNode));
        resetAllButtonNode.setOffset(concentrationDisplayNode.getXOffset() + pDimension2.getWidth() / 2.0 - resetAllButtonNode.getFullBoundsReference().getWidth() / 2.0, soluteControlNode.getYOffset());
        showValuesNode.setOffset(resetAllButtonNode.getFullBoundsReference().getMinX() - showValuesNode.getFullBoundsReference().getWidth() - 20.0, soluteControlNode.getYOffset());
        this.scaleRootNodeToFitStage();
        this.centerRootNodeOnStage();
    }

    public void reset() {
        super.reset();
        this.valuesVisible.reset();
    }
}

