/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ColorRange;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.colorado.phet.molarity.MolarityConstants;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySimSharing;
import edu.colorado.phet.molarity.model.Solution;
import edu.colorado.phet.molarity.view.DualLabelNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcentrationDisplayNode
extends PNode {
    public ConcentrationDisplayNode(String string, String string2, final PDimension pDimension, final Solution solution, final DoubleRange doubleRange, String string3, String string4, String string5, Property<Boolean> property) {
        HTMLNode hTMLNode = new HTMLNode(string, Color.BLACK, MolarityConstants.TITLE_FONT);
        HTMLNode hTMLNode2 = new HTMLNode(string2, Color.BLACK, MolarityConstants.SUBTITLE_FONT);
        final BarNode barNode = new BarNode(pDimension);
        final PointerNode pointerNode = new PointerNode(pDimension, doubleRange, solution.concentration.get(), string3, property);
        DualLabelNode dualLabelNode = new DualLabelNode(MolarityConstants.RANGE_FORMAT.format(doubleRange.getMax()), string5, property, MolarityConstants.RANGE_FONT);
        DualLabelNode dualLabelNode2 = new DualLabelNode(MolarityConstants.RANGE_FORMAT.format(doubleRange.getMin()), string4, property, MolarityConstants.RANGE_FONT);
        final SaturationIndicatorNode saturationIndicatorNode = new SaturationIndicatorNode(pDimension, solution.getSaturatedConcentration(), doubleRange.getMax());
        this.addChild(hTMLNode);
        this.addChild(hTMLNode2);
        this.addChild(barNode);
        this.addChild(dualLabelNode);
        this.addChild(dualLabelNode2);
        this.addChild(pointerNode);
        this.addChild(saturationIndicatorNode);
        dualLabelNode.setOffset(barNode.getFullBoundsReference().getCenterX(), barNode.getFullBoundsReference().getMinY() - dualLabelNode.getFullBoundsReference().getHeight() - 3.0);
        dualLabelNode2.setOffset(barNode.getFullBoundsReference().getCenterX(), barNode.getFullBoundsReference().getMaxY() + 3.0);
        hTMLNode2.setOffset(barNode.getFullBounds().getCenterX() - hTMLNode2.getFullBoundsReference().getWidth() / 2.0, dualLabelNode.getFullBoundsReference().getMinY() - hTMLNode2.getFullBoundsReference().getHeight() - 8.0);
        hTMLNode.setOffset(barNode.getFullBounds().getCenterX() - hTMLNode.getFullBoundsReference().getWidth() / 2.0, hTMLNode2.getFullBoundsReference().getMinY() - hTMLNode.getFullBoundsReference().getHeight() - 2.0);
        solution.concentration.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                pointerNode.setValue(d);
            }
        });
        solution.solute.addObserver(new SimpleObserver(){

            public void update() {
                GradientPaint gradientPaint = ConcentrationDisplayNode.createGradient(solution.solute.get().solutionColor, pDimension.getHeight(), solution.getSaturatedConcentration(), doubleRange.getMax());
                barNode.setPaint(gradientPaint);
                pointerNode.setArrowPaint(gradientPaint);
                saturationIndicatorNode.setSaturationPoint(solution.getSaturatedConcentration());
                saturationIndicatorNode.setVisible(solution.getSaturatedConcentration() < doubleRange.getMax());
            }
        });
        barNode.addInputEventListener(new NonInteractiveEventHandler(MolaritySimSharing.UserComponents.concentrationBar));
        pointerNode.addInputEventListener(new NonInteractiveEventHandler(MolaritySimSharing.UserComponents.concentrationPointer));
    }

    private static GradientPaint createGradient(ColorRange colorRange, double d, double d2, double d3) {
        double d4 = d - d * (d2 / d3);
        return new GradientPaint(0.0f, (float)d4, colorRange.getMax(), 0.0f, (float)d, colorRange.getMin());
    }

    private static class BarNode
    extends PPath {
        public BarNode(PDimension pDimension) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PointerNode
    extends PComposite {
        private final PDimension barSize;
        private final String units;
        private final Function.LinearFunction function;
        private PNode arrowNode;
        private final PText valueNode;

        public PointerNode(PDimension pDimension, DoubleRange doubleRange, double d, String string, Property<Boolean> property) {
            this.barSize = pDimension;
            this.units = string;
            this.function = new Function.LinearFunction(doubleRange.getMin(), doubleRange.getMax(), pDimension.getHeight(), 0.0);
            this.arrowNode = new PNode();
            this.valueNode = new PText(){
                {
                    this.setFont(MolarityConstants.VALUE_FONT);
                }
            };
            this.addChild(this.valueNode);
            this.setValue(d);
            property.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    PointerNode.this.valueNode.setVisible(bl);
                }
            });
        }

        public void setArrowPaint(Paint paint) {
            this.arrowNode.setPaint(paint);
        }

        public void setValue(double d) {
            double d2 = this.function.evaluate(d);
            Paint paint = this.arrowNode.getPaint();
            this.removeChild(this.arrowNode);
            this.arrowNode = new ArrowNode(new Point2D.Double(this.barSize.getWidth() + 35.0, d2), new Point2D.Double(this.barSize.getWidth(), d2), 25.0, 25.0, 13.0);
            this.arrowNode.setPaint(paint);
            this.addChild(this.arrowNode);
            String string = MessageFormat.format(MolarityResources.Strings.PATTERN__0VALUE__1UNITS, MolarityConstants.VALUE_FORMAT.format(d), this.units);
            this.valueNode.setText(string);
            this.valueNode.setOffset(this.arrowNode.getFullBoundsReference().getMaxX() + 3.0, this.arrowNode.getFullBoundsReference().getCenterY() - this.valueNode.getFullBoundsReference().getHeight() / 2.0);
        }
    }

    private static class SaturationIndicatorNode
    extends PPath {
        private PDimension barSize;
        private double maxConcentration;

        public SaturationIndicatorNode(PDimension pDimension, double d, double d2) {
            this.barSize = pDimension;
            this.maxConcentration = d2;
            this.setPaint(Color.LIGHT_GRAY);
            this.setSaturationPoint(d);
        }

        public void setSaturationPoint(double d) {
            double d2 = this.barSize.getHeight() - this.barSize.getHeight() * (d / this.maxConcentration);
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.barSize.getWidth(), d2));
        }
    }
}

