/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.colorado.phet.molarity.model.Solution;
import edu.colorado.phet.molarity.view.BeakerImageNode;
import edu.colorado.phet.molarity.view.BeakerLabelNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeakerNode
extends PComposite {
    private static final Color TICK_COLOR = Color.GRAY;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final String[] MAJOR_TICK_LABELS = new String[]{"\u00bd", "1"};
    private static final Font TICK_LABEL_FONT = new PhetFont(20);
    private static final Color TICK_LABEL_COLOR = Color.DARK_GRAY;
    private final BeakerImageNode beakerImageNode;
    private final BeakerLabelNode labelNode;
    private final ArrayList<PText> tickLabelNodes;

    public BeakerNode(IUserComponent iUserComponent, Solution solution, double d, String string, String string2, Font font, Font font2, PDimension pDimension, final double d2, final double d3, Property<Boolean> property) {
        this.beakerImageNode = new BeakerImageNode(){
            {
                this.getTransformReference(true).scale(d2, d3);
            }
        };
        final PDimension pDimension2 = this.beakerImageNode.getCylinderSize();
        Point2D point2D = this.beakerImageNode.getCylinderOffset();
        final double d4 = this.beakerImageNode.getCylinderEndHeight();
        this.beakerImageNode.setOffset(-point2D.getX(), -point2D.getY());
        PPath pPath = new PPath(){
            {
                this.setPathTo(new Arc2D.Double(0.0, pDimension2.getHeight() - d4 / 2.0, pDimension2.getWidth(), d4, 5.0, 170.0, 0));
                this.setStroke(new BasicStroke(2.0f));
                this.setStrokePaint(new Color(150, 150, 150, 100));
            }
        };
        this.addChild(pPath);
        this.addChild(this.beakerImageNode);
        this.tickLabelNodes = new ArrayList();
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        int n = (int)Math.round(d / 0.1);
        double d5 = pDimension2.getHeight();
        double d6 = pDimension2.getHeight() / (double)n;
        for (int i = 1; i <= n; ++i) {
            PPath pPath2;
            double d7 = d5 - (double)i * d6 - d4 / 2.0;
            if (i % 5 == 0) {
                pPath2 = new PPath(new Arc2D.Double(0.0, d7, pDimension2.getWidth(), d4, 195.0, 30.0, 0)){
                    {
                        this.setStroke(MAJOR_TICK_STROKE);
                        this.setStrokePaint(TICK_COLOR);
                    }
                };
                pComposite.addChild(pPath2);
                int n2 = i / 5 - 1;
                if (n2 >= MAJOR_TICK_LABELS.length) continue;
                String string3 = MAJOR_TICK_LABELS[n2] + string;
                PText pText = new PText(string3){
                    {
                        this.setFont(TICK_LABEL_FONT);
                        this.setTextPaint(TICK_LABEL_COLOR);
                    }
                };
                pComposite.addChild(pText);
                pText.setOffset(pPath2.getFullBounds().getMaxX() + 8.0, pPath2.getFullBounds().getMaxY() - pText.getFullBoundsReference().getHeight() / 2.0);
                this.tickLabelNodes.add(pText);
                continue;
            }
            pPath2 = new PPath(new Arc2D.Double(0.0, d7, pDimension2.getWidth(), d4, 195.0, 15.0, 0)){
                {
                    this.setStroke(MINOR_TICK_STROKE);
                    this.setStrokePaint(TICK_COLOR);
                }
            };
            pComposite.addChild(pPath2);
        }
        this.labelNode = new BeakerLabelNode(solution, pDimension, font, font2, string2, property);
        this.addChild(this.labelNode);
        this.labelNode.setOffset(pDimension2.getWidth() / 2.0, 0.15 * pDimension2.getHeight());
        property.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                BeakerNode.this.setValuesVisible(bl);
            }
        });
        this.addInputEventListener(new NonInteractiveEventHandler(iUserComponent));
    }

    public void setValuesVisible(boolean bl) {
        for (PText pText : this.tickLabelNodes) {
            pText.setVisible(bl);
        }
    }

    public PDimension getCylinderSize() {
        return this.beakerImageNode.getCylinderSize();
    }

    public double getCylinderEndHeight() {
        return this.beakerImageNode.getCylinderEndHeight();
    }
}

