/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.molarity.MolarityResources;
import edu.colorado.phet.molarity.MolaritySymbols;
import edu.colorado.phet.molarity.model.Solution;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeakerLabelNode
extends PComposite {
    private static final Logger LOGGER = LoggingUtils.getLogger(BeakerLabelNode.class.getCanonicalName());
    private static final DecimalFormat CONCENTRATION_FORMAT = new DefaultDecimalFormat("0.00");
    private final Solution solution;
    private final String concentrationUnits;
    private final HTMLNode formulaNode;
    private final PText concentrationNode;
    private final PNode textParentNode;
    private final PPath backgroundNode;

    public BeakerLabelNode(Solution solution, final PDimension pDimension, final Font font, final Font font2, String string, Property<Boolean> property) {
        this.solution = solution;
        this.concentrationUnits = string;
        this.formulaNode = new HTMLNode("?"){
            {
                super(string);
                this.setFont(font);
            }
        };
        this.concentrationNode = new PText("?"){
            {
                super(string);
                this.setFont(font2);
            }
        };
        this.textParentNode = new PNode();
        this.backgroundNode = new PPath(){
            {
                this.setPaint(ColorUtils.createColor(Color.WHITE, 150));
                this.setStrokePaint(Color.LIGHT_GRAY);
                this.setPathTo(new RoundRectangle2D.Double(-pDimension.getWidth() / 2.0, 0.0, pDimension.getWidth(), pDimension.getHeight(), 10.0, 10.0));
            }
        };
        this.addChild(this.backgroundNode);
        this.textParentNode.addChild(this.formulaNode);
        this.addChild(this.textParentNode);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                BeakerLabelNode.this.updateFormula();
            }
        };
        richSimpleObserver.observe(solution.concentration, solution.volume, solution.solute);
        solution.concentration.addObserver(new SimpleObserver(){

            public void update() {
                BeakerLabelNode.this.updateConcentration();
            }
        });
        property.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                PText pText = BeakerLabelNode.this.concentrationNode;
                if (bl.booleanValue()) {
                    // empty if block
                }
                pText.setVisible(false);
                BeakerLabelNode.this.updateLayout();
            }
        });
    }

    private void updateFormula() {
        String string = this.solution.volume.get() == 0.0 ? "" : (this.solution.concentration.get() == 0.0 ? MolaritySymbols.WATER : this.solution.solute.get().formula);
        this.formulaNode.setHTML(string);
        this.updateLayout();
    }

    private void updateConcentration() {
        String string = CONCENTRATION_FORMAT.format(this.solution.concentration.get());
        String string2 = MessageFormat.format(MolarityResources.Strings.PATTERN__0VALUE__1UNITS, string, this.concentrationUnits);
        this.concentrationNode.setText(MessageFormat.format(MolarityResources.Strings.PATTERN__PARENTHESES__0TEXT, string2));
        this.updateLayout();
    }

    private void updateLayout() {
        if (this.concentrationNode.getVisible()) {
            // empty if block
        }
        this.concentrationNode.setOffset(this.formulaNode.getOffset());
        double d = (this.backgroundNode.getFullBoundsReference().getWidth() - 10.0) / this.textParentNode.getFullBoundsReference().getWidth();
        double d2 = (this.backgroundNode.getFullBoundsReference().getHeight() - 10.0) / this.textParentNode.getFullBoundsReference().getHeight();
        if (d < 1.0 || d2 < 1.0) {
            double d3 = Math.min(d, d2);
            LOGGER.info("scaling beaker label by " + d3);
            this.textParentNode.setScale(d3);
        }
        this.textParentNode.setOffset(this.backgroundNode.getFullBoundsReference().getCenterX() - this.textParentNode.getFullBoundsReference().getWidth() / 2.0, this.backgroundNode.getFullBoundsReference().getCenterY() - this.textParentNode.getFullBoundsReference().getHeight() / 2.0);
    }
}

