/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.view;

import edu.colorado.phet.molarity.MolarityResources;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

class BeakerImageNode
extends PImage {
    private static final Point2D CYLINDER_UPPER_LEFT = new Point2D.Double(98.0, 192.0);
    private static final Point2D CYLINDER_LOWER_RIGHT = new Point2D.Double(526.0, 644.0);
    private static final Point2D CYLINDER_END_BACKGROUND = new Point2D.Double(210.0, 166.0);
    private static final Point2D CYLINDER_END_FOREGROUND = new Point2D.Double(210.0, 218.0);

    public BeakerImageNode() {
        super(MolarityResources.Images.BEAKER);
    }

    public PDimension getCylinderSize() {
        Point2D point2D = this.getTransformedPoint(CYLINDER_UPPER_LEFT);
        Point2D point2D2 = this.getTransformedPoint(CYLINDER_LOWER_RIGHT);
        return new PDimension(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public Point2D getCylinderOffset() {
        return this.getTransformedPoint(CYLINDER_UPPER_LEFT);
    }

    public double getCylinderEndHeight() {
        return this.getTransformedPoint(CYLINDER_END_FOREGROUND).getY() - this.getTransformedPoint(CYLINDER_END_BACKGROUND).getY();
    }

    private Point2D getTransformedPoint(Point2D point2D) {
        return this.getTransform().transform(point2D, null);
    }
}

