/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.molarity.model;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.molarity.model.Solute;
import edu.colorado.phet.molarity.model.Solvent;

public class Solution
implements Resettable {
    public final Solvent solvent;
    public final Property<Solute> solute;
    public final Property<Double> soluteAmount;
    public final Property<Double> volume;
    public final CompositeProperty<Double> concentration;
    public final CompositeProperty<Double> precipitateAmount;

    public Solution(Solvent solvent, Solute solute, double d, double d2) {
        this.solvent = solvent;
        this.solute = new Property<Solute>(solute);
        this.soluteAmount = new Property<Double>(d);
        this.volume = new Property<Double>(d2);
        this.concentration = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                double d = Solution.this.volume.get();
                Double d2 = Solution.this.soluteAmount.get();
                if (d > 0.0) {
                    return Math.min(Solution.this.getSaturatedConcentration(), d2 / d);
                }
                return 0.0;
            }
        }, this.solute, this.soluteAmount, this.volume);
        this.precipitateAmount = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                double d = Solution.this.volume.get();
                Double d2 = Solution.this.soluteAmount.get();
                if (d > 0.0) {
                    return Math.max(0.0, d * (d2 / d - Solution.this.getSaturatedConcentration()));
                }
                return d2;
            }
        }, this.solute, this.soluteAmount, this.volume);
    }

    public double getSaturatedConcentration() {
        return this.solute.get().saturatedConcentration;
    }

    public boolean isSaturated() {
        return this.precipitateAmount.get() != 0.0;
    }

    public void reset() {
        this.solute.reset();
        this.soluteAmount.reset();
        this.volume.reset();
    }
}

