/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.sponsorship;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.sponsorship.SponsorProperties;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class SponsorPanel
extends GridPanel {
    public SponsorPanel(PhetApplicationConfig phetApplicationConfig) {
        SponsorProperties sponsorProperties = new SponsorProperties(phetApplicationConfig);
        assert (sponsorProperties.isWellFormed());
        String string = sponsorProperties.getImageResourceName();
        String string2 = sponsorProperties.getActualURL();
        String string3 = sponsorProperties.getVisibleURL();
        String string4 = sponsorProperties.getSinceDate();
        int n = 40;
        int n2 = 20;
        this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(n2, n, n2, n)));
        this.setGridX(0);
        this.setAnchor(GridPanel.Anchor.CENTER);
        this.add(new JLabel("Sponsored by"){
            {
                this.setFont(new PhetFont(18));
            }
        });
        this.add(Box.createVerticalStrut(15));
        if (string != null) {
            this.add(new JLabel(new ImageIcon(phetApplicationConfig.getResourceLoader().getImage(string))));
        }
        if (string2 != null && string3 != null) {
            this.add(Box.createVerticalStrut(15));
            this.add(SponsorPanel.createInteractiveHTMLPane(string2, string3, new PhetFont(14)));
        }
        this.add(Box.createVerticalStrut(15));
        if (string4 != null) {
            this.add(new JLabel(MessageFormat.format("(since {0})", string4)){
                {
                    this.setFont(new PhetFont(10));
                }
            });
        }
    }

    private static HTMLUtils.InteractiveHTMLPane createInteractiveHTMLPane(String string, String string2, Font font) {
        return new HTMLUtils.InteractiveHTMLPane(HTMLUtils.createStyledHTMLFromFragment("<a href=\"" + string + "\" target=\"_blank\">" + string2, font)){
            {
                this.setOpaque(false);
            }
        };
    }
}

