/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.microwaves.common.graphics.ApparatusPanel;
import edu.colorado.phet.microwaves.common.graphics.ModelViewTransform2D;
import edu.colorado.phet.microwaves.coreadditions.TxObservingGraphic;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.model.waves.WaveMedium;
import edu.colorado.phet.microwaves.view.graphics.splines.CubicSpline;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Observable;

public class FieldLatticeView
extends TxObservingGraphic {
    private static Color splineColor = new Color(0, 200, 0);
    private BasicStroke splineStroke = new BasicStroke(2.0f);
    private Point2D.Double latticePtLocation = new Point2D.Double();
    private Point2D.Double origin;
    private double latticeSpacingX;
    private double latticeSpacingY;
    private int numLatticePtsX;
    private int numLatticePtsY;
    private Vector2D[][] latticePts;
    private CubicSpline spline = new CubicSpline();
    private boolean autoscaleEnabled = false;
    private WaveMedium waveMedium;
    private int latticeViewSpacingY;
    private int latticeViewSpacingX;
    private Point originView = new Point();
    private int viewType;
    private boolean splineVisible;
    private static Color arrowColor = new Color(235, 235, 235);
    private static Color curveColor = new Color(80, 0, 230);
    private static Polygon arrowHead = new Polygon();
    private static int maxWidth = 10;
    private static int arrowWidth = 10;
    private static int arrowHeadWidth = 20;
    BasicStroke arrowStroke = new BasicStroke(4.0f);
    private static float s_scaleFactor = 100.0f;
    private static int s_latticePtDiam = 5;
    private static BufferedImage s_latticePtImg = new BufferedImage(s_latticePtDiam, s_latticePtDiam, 2);
    private int VIEW_NONE = 0;
    private int VIEW_FULL = 1;
    private int VIEW_SINGLE = 2;

    public FieldLatticeView(WaveMedium waveMedium, Point2D.Double double_, double d, double d2, double d3, double d4, ApparatusPanel apparatusPanel, ModelViewTransform2D modelViewTransform2D) {
        super(modelViewTransform2D);
        this.origin = double_;
        this.latticeSpacingX = d3;
        this.latticeSpacingY = d4;
        this.numLatticePtsX = (int)(1.0 + (d - 1.0) / d3);
        this.numLatticePtsY = (int)(1.0 + (d2 - 1.0) / d4);
        this.latticePts = new Vector2D[this.numLatticePtsY][this.numLatticePtsX];
        for (int i = 0; i < this.numLatticePtsY; ++i) {
            for (int j = 0; j < this.numLatticePtsX; ++j) {
                this.latticePts[i][j] = new Vector2D();
            }
        }
        this.waveMedium = waveMedium;
        waveMedium.addObserver(this);
        this.update(null, null);
    }

    public synchronized void paint(Graphics2D graphics2D) {
        if (this.viewType != this.VIEW_NONE) {
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            GraphicsUtil.setAntiAliasingOn(graphics2D);
            graphics2D.setColor(Color.BLUE);
            float f = 1.0f;
            if (this.autoscaleEnabled) {
                f = this.getAutoscaleFactor();
            }
            for (int i = 0; i < this.numLatticePtsY; ++i) {
                boolean bl;
                boolean bl2 = bl = i == this.numLatticePtsX / 2 - 1;
                if (this.splineVisible && bl) {
                    this.spline.reset();
                }
                for (int j = 0; j < this.numLatticePtsX; ++j) {
                    if (this.viewType != this.VIEW_FULL && (this.viewType != this.VIEW_SINGLE || !bl)) continue;
                    int n = this.originView.x + j * this.latticeViewSpacingX - 1;
                    int n2 = this.originView.y + i * this.latticeViewSpacingY - 1;
                    int n3 = (int)(this.latticePts[i][j].getX() * f);
                    int n4 = -((int)(this.latticePts[i][j].getY() * f));
                    double d = Math.sqrt(n3 * n3 + n4 * n4);
                    d = Math.min(d, (double)Math.min(this.latticeViewSpacingX, Math.abs(this.latticeViewSpacingY)));
                    if (this.viewType == this.VIEW_FULL) {
                        int n5 = arrowWidth;
                        int n6 = arrowHeadWidth;
                        arrowWidth = (int)(4.0 * (d / 20.0));
                        arrowHeadWidth = (int)(8.0 * (d / 20.0));
                        float f2 = (float)d / (float)this.latticeViewSpacingY;
                        Composite composite = graphics2D.getComposite();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                        this.drawHollowArrow(graphics2D, n, n2 - n4 / 2, n, n2 + n4 / 2);
                        graphics2D.setComposite(composite);
                        arrowWidth = n5;
                        arrowHeadWidth = n6;
                    }
                    if (this.viewType == this.VIEW_SINGLE) {
                        this.drawHollowArrow(graphics2D, n, n2, n, n2 + n4);
                    }
                    if (!this.splineVisible || !bl) continue;
                    this.spline.addPoint(n, n2 + n4);
                }
                if (!this.splineVisible || !bl) continue;
                graphics2D.setColor(splineColor);
                graphics2D.setStroke(this.splineStroke);
                this.spline.paint(graphics2D);
            }
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    private float getAutoscaleFactor() {
        float f = 0.0f;
        for (int i = 0; i < this.numLatticePtsY; ++i) {
            for (int j = 0; j < this.numLatticePtsX; ++j) {
                float f2 = Math.max(f, Math.max(this.latticePts[i][j].getX(), this.latticePts[i][j].getY()));
                if (Float.isNaN(f2)) continue;
                f = f2;
            }
        }
        return (int)(this.latticeSpacingX / (double)f);
    }

    public synchronized void update(Observable observable, Object object) {
        for (int i = 0; i < this.numLatticePtsY; ++i) {
            for (int j = 0; j < this.numLatticePtsX; ++j) {
                this.latticePtLocation.x = (double)j * this.latticeSpacingX + this.origin.getX();
                this.latticePtLocation.y = (double)i * this.latticeSpacingY + this.origin.getY();
                Vector2D vector2D = this.waveMedium.getFieldAtLocation(this.latticePtLocation);
                this.latticePts[i][j].setX(vector2D.getX() * s_scaleFactor);
                this.latticePts[i][j].setY(vector2D.getY() * s_scaleFactor);
            }
        }
        this.latticeViewSpacingX = (int)this.latticeSpacingX;
        this.latticeViewSpacingY = (int)this.latticeSpacingY;
        this.originView.setLocation(this.origin.x, this.origin.y);
    }

    private void drawHollowArrow(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (n != n3 || n2 != n4) {
            graphics2D.setColor(arrowColor);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n5 = n4 - Math.min(Math.abs(n4 - n2) / 2, maxWidth) * MathUtil.getSign(n4 - n2);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n - arrowWidth / 2, n2);
            generalPath.lineTo(n - arrowWidth / 2, n5);
            generalPath.lineTo(n - arrowHeadWidth / 2, n5);
            generalPath.lineTo(n, n4);
            generalPath.lineTo(n + arrowHeadWidth / 2, n5);
            generalPath.lineTo(n + arrowWidth / 2, n5);
            generalPath.lineTo(n + arrowWidth / 2, n2);
            generalPath.lineTo(n - arrowWidth / 2, n2);
            graphics2D.draw(generalPath);
        }
    }

    public void setViewOff() {
        this.viewType = this.VIEW_NONE;
        this.splineVisible = false;
    }

    public void setViewFull() {
        this.viewType = this.VIEW_FULL;
        this.splineVisible = false;
    }

    public void setViewSingle() {
        this.viewType = this.VIEW_SINGLE;
        this.splineVisible = false;
    }

    public void setViewSpline() {
        this.splineVisible = true;
    }
}

