/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model.waves;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.model.waves.Wave;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Observable;

public class WaveMedium
extends Observable
implements ModelElement {
    private ArrayList wavefronts = new ArrayList();
    private Vector2D tempVector2D = new Vector2D();

    public void stepInTime(double d) {
        for (int i = 0; i < this.wavefronts.size(); ++i) {
            Wave wave = (Wave)this.wavefronts.get(i);
            wave.stepInTime(d);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void addWavefront(Wave wave) {
        this.wavefronts.add(wave);
    }

    public Vector2D getFieldAtLocation(Point2D.Double double_) {
        this.tempVector2D.setX(0.0f);
        this.tempVector2D.setY(0.0f);
        float f = 0.0f;
        for (int i = 0; i < this.wavefronts.size(); ++i) {
            Wave wave = (Wave)this.wavefronts.get(i);
            f += wave.getAmplitude()[(int)double_.getX()];
        }
        this.tempVector2D.setY(f);
        return this.tempVector2D;
    }

    public void clear() {
        this.wavefronts.clear();
    }
}

