/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.common.graphics;

import edu.colorado.phet.microwaves.common.graphics.CompositeTransformListener;
import edu.colorado.phet.microwaves.common.graphics.TransformListener;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform2D {
    private Rectangle2D.Double modelBounds;
    private Rectangle viewBounds;
    private CompositeTransformListener listeners = new CompositeTransformListener();

    public ModelViewTransform2D(Rectangle2D.Double double_, Rectangle rectangle) {
        this.modelBounds = double_;
        this.viewBounds = rectangle;
        if (rectangle.getWidth() <= 0.0) {
            throw new RuntimeException("View Bounds width must be positive.");
        }
        if (rectangle.getHeight() <= 0.0) {
            throw new RuntimeException("View Bounds height must be positive.");
        }
    }

    public void addTransformListener(TransformListener transformListener) {
        this.listeners.addTransformListener(transformListener);
    }

    public AffineTransform toAffineTransform() {
        return this.toAffineTransform(new Point2D.Double());
    }

    public AffineTransform toAffineTransform(Point2D.Double double_) {
        double d = (double)this.viewBounds.width / this.modelBounds.width;
        double d2 = 0.0;
        double d3 = (double)this.viewBounds.x - d * this.modelBounds.x;
        double d4 = 0.0;
        double d5 = (double)(-this.viewBounds.height) / this.modelBounds.height;
        double d6 = (double)this.viewBounds.y + (double)this.viewBounds.height / this.modelBounds.height * (this.modelBounds.y + this.modelBounds.height);
        return new AffineTransform(d, d4, d2, d5, d3, d6);
    }

    public Point2D.Double viewToModel(int n, int n2) {
        return new Point2D.Double(this.viewToModelX(n), this.viewToModelY(n2));
    }

    public double viewToModelY(int n) {
        double d = (double)(-this.viewBounds.height) / this.modelBounds.height;
        double d2 = (double)(n - this.viewBounds.y) / d + this.modelBounds.height + this.modelBounds.y;
        return d2;
    }

    public double viewToModelX(double d) {
        double d2 = this.modelBounds.width / (double)this.viewBounds.width;
        return d2 * (d - (double)this.viewBounds.x) + this.modelBounds.x;
    }
}

