/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.membranechannels.view.ToolBoxItem;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public abstract class ToolBox
extends PNode {
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Stroke OUTLINE_STROKE = new BasicStroke(2.0f);
    protected PhetPPath boxNode;
    private ArrayList<ToolBoxItem> grabbableItems = new ArrayList();
    private PText captionNode = null;

    public ToolBox(PDimension pDimension) {
        this.boxNode = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight(), 15.0, 15.0), BACKGROUND_COLOR, OUTLINE_STROKE, Color.BLACK);
        this.addChild(this.boxNode);
    }

    protected void addToolBoxItem(ToolBoxItem toolBoxItem) {
        this.grabbableItems.add(toolBoxItem);
        this.addChild(toolBoxItem);
    }

    protected void setCaption(String string) {
        if (this.captionNode != null) {
            this.removeChild(this.captionNode);
        }
        this.captionNode = new PText(string);
        this.captionNode.setFont(new PhetFont(24));
        double d = this.boxNode.getFullBoundsReference().width * 0.8;
        if (this.captionNode.getFullBoundsReference().width > d) {
            double d2 = d / this.captionNode.getFullBoundsReference().width;
            this.captionNode.setScale(d2);
        }
        this.addChild(this.captionNode);
    }

    protected void updateLayout() {
        if (this.grabbableItems.size() > 0) {
            double d = this.boxNode.getFullBoundsReference().width / (double)(this.grabbableItems.size() + 1);
            double d2 = this.boxNode.getFullBoundsReference().height * 0.3;
            for (int i = 0; i < this.grabbableItems.size(); ++i) {
                this.grabbableItems.get(i).setOffset(d * (double)(i + 1), d2);
            }
        }
        if (this.captionNode != null) {
            this.captionNode.setOffset(this.boxNode.getFullBoundsReference().width / 2.0 - this.captionNode.getFullBoundsReference().width / 2.0, this.boxNode.getFullBoundsReference().height * 0.7);
        }
    }
}

