/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Cursor;
import javax.swing.JComponent;

public class RestoreDefaultOnReleaseCursorHandler
extends PBasicInputEventHandler {
    public static final Cursor CROSSHAIR = Cursor.getPredefinedCursor(1);
    public static final Cursor DEFAULT = Cursor.getPredefinedCursor(0);
    public static final Cursor HAND = Cursor.getPredefinedCursor(12);
    private static final CursorManager manager = new CursorManager();
    private Cursor cursor;

    public RestoreDefaultOnReleaseCursorHandler() {
        this(HAND);
    }

    public RestoreDefaultOnReleaseCursorHandler(int n) {
        this(Cursor.getPredefinedCursor(n));
    }

    public RestoreDefaultOnReleaseCursorHandler(Cursor cursor) {
        this.cursor = cursor;
    }

    public void mouseEntered(PInputEvent pInputEvent) {
        manager.mouseEntered(pInputEvent, this.cursor);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        manager.mousePressed(pInputEvent, this.cursor);
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        manager.mouseReleased((JComponent)((Object)pInputEvent.getComponent()));
    }

    public void mouseExited(PInputEvent pInputEvent) {
        manager.mouseExited(pInputEvent);
    }

    private static class CursorManager {
        private CursorManager() {
        }

        public void mousePressed(PInputEvent pInputEvent, Cursor cursor) {
            JComponent jComponent = (JComponent)((Object)pInputEvent.getComponent());
            if (jComponent.getCursor() != cursor) {
                jComponent.setCursor(cursor);
            }
        }

        public void mouseEntered(PInputEvent pInputEvent, Cursor cursor) {
            if (!pInputEvent.isLeftMouseButton()) {
                ((JComponent)((Object)pInputEvent.getComponent())).setCursor(cursor);
            }
        }

        public void mouseReleased(JComponent jComponent) {
            jComponent.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseExited(PInputEvent pInputEvent) {
            if (!pInputEvent.isLeftMouseButton()) {
                ((JComponent)((Object)pInputEvent.getComponent())).setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

